/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory.quota;

import com.github.fge.lambdas.Throwing;
import com.github.steveash.guavate.Guavate;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.core.Domain;
import org.apache.james.core.quota.QuotaCount;
import org.apache.james.core.quota.QuotaSize;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.MaxQuotaManager;
import org.apache.james.util.OptionalUtils;

public class InMemoryPerUserMaxQuotaManager
implements MaxQuotaManager {
    private Optional<QuotaCount> maxMessage = Optional.empty();
    private Optional<QuotaSize> maxStorage = Optional.empty();
    private final Map<Domain, QuotaCount> domainMaxMessage = new ConcurrentHashMap<Domain, QuotaCount>();
    private final Map<Domain, QuotaSize> domainMaxStorage = new ConcurrentHashMap<Domain, QuotaSize>();
    private final Map<String, QuotaSize> userMaxStorage = new ConcurrentHashMap<String, QuotaSize>();
    private final Map<String, QuotaCount> userMaxMessage = new ConcurrentHashMap<String, QuotaCount>();

    public void setGlobalMaxStorage(QuotaSize maxStorage) {
        this.maxStorage = Optional.of(maxStorage);
    }

    public void setDomainMaxMessage(Domain domain, QuotaCount count) {
        this.domainMaxMessage.put(domain, count);
    }

    public void setDomainMaxStorage(Domain domain, QuotaSize size) {
        this.domainMaxStorage.put(domain, size);
    }

    public void removeDomainMaxMessage(Domain domain) {
        this.domainMaxMessage.remove(domain);
    }

    public void removeDomainMaxStorage(Domain domain) {
        this.domainMaxStorage.remove(domain);
    }

    public Optional<QuotaSize> getMaxStorage(QuotaRoot quotaRoot) {
        return OptionalUtils.or((Optional[])new Optional[]{Optional.ofNullable(this.userMaxStorage.get(quotaRoot.getValue())), quotaRoot.getDomain().flatMap(this::getDomainMaxStorage), this.maxStorage});
    }

    public Optional<QuotaCount> getMaxMessage(QuotaRoot quotaRoot) {
        return OptionalUtils.or((Optional[])new Optional[]{Optional.ofNullable(this.userMaxMessage.get(quotaRoot.getValue())), quotaRoot.getDomain().flatMap(this::getDomainMaxMessage), this.maxMessage});
    }

    public Map<Quota.Scope, QuotaCount> listMaxMessagesDetails(QuotaRoot quotaRoot) {
        Function domainQuotaFunction = Throwing.function(this::getDomainMaxMessage).sneakyThrow();
        return (Map)Stream.of(Pair.of((Object)Quota.Scope.User, Optional.ofNullable(this.userMaxMessage.get(quotaRoot.getValue()))), Pair.of((Object)Quota.Scope.Domain, quotaRoot.getDomain().flatMap(domainQuotaFunction)), Pair.of((Object)Quota.Scope.Global, this.maxMessage)).filter(pair -> ((Optional)pair.getValue()).isPresent()).collect(Guavate.toImmutableMap(Pair::getKey, value -> (QuotaCount)((Optional)value.getValue()).get()));
    }

    public Map<Quota.Scope, QuotaSize> listMaxStorageDetails(QuotaRoot quotaRoot) {
        Function domainQuotaFunction = Throwing.function(this::getDomainMaxStorage).sneakyThrow();
        return (Map)Stream.of(Pair.of((Object)Quota.Scope.User, Optional.ofNullable(this.userMaxStorage.get(quotaRoot.getValue()))), Pair.of((Object)Quota.Scope.Domain, quotaRoot.getDomain().flatMap(domainQuotaFunction)), Pair.of((Object)Quota.Scope.Global, this.maxStorage)).filter(pair -> ((Optional)pair.getValue()).isPresent()).collect(Guavate.toImmutableMap(Pair::getKey, value -> (QuotaSize)((Optional)value.getValue()).get()));
    }

    public void setGlobalMaxMessage(QuotaCount maxMessage) {
        this.maxMessage = Optional.of(maxMessage);
    }

    public Optional<QuotaCount> getDomainMaxMessage(Domain domain) {
        return Optional.ofNullable(this.domainMaxMessage.get(domain));
    }

    public Optional<QuotaSize> getDomainMaxStorage(Domain domain) {
        return Optional.ofNullable(this.domainMaxStorage.get(domain));
    }

    public void setMaxStorage(QuotaRoot user, QuotaSize maxStorageQuota) {
        this.userMaxStorage.put(user.getValue(), maxStorageQuota);
    }

    public void setMaxMessage(QuotaRoot quotaRoot, QuotaCount maxMessageCount) {
        this.userMaxMessage.put(quotaRoot.getValue(), maxMessageCount);
    }

    public Optional<QuotaSize> getGlobalMaxStorage() {
        return this.maxStorage;
    }

    public Optional<QuotaCount> getGlobalMaxMessage() {
        return this.maxMessage;
    }

    public void removeMaxMessage(QuotaRoot quotaRoot) {
        this.userMaxMessage.remove(quotaRoot.getValue());
    }

    public void removeMaxStorage(QuotaRoot quotaRoot) {
        this.userMaxStorage.remove(quotaRoot.getValue());
    }

    public void removeGlobalMaxStorage() {
        this.maxStorage = Optional.empty();
    }

    public void removeGlobalMaxMessage() {
        this.maxMessage = Optional.empty();
    }
}

