/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.lib;

import java.util.Optional;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.util.OptionalUtils;

public class SeparatorUtil {
    public static String getSeparator(String targetString) {
        return OptionalUtils.or((Optional[])new Optional[]{SeparatorUtil.mayContainComma(targetString), SeparatorUtil.mayContainSemicolon(targetString), SeparatorUtil.mayContainColon(targetString)}).orElse("");
    }

    private static Optional<String> mayContainComma(String targetString) {
        return SeparatorUtil.mayContain(targetString, ",");
    }

    private static Optional<String> mayContainSemicolon(String targetString) {
        return SeparatorUtil.mayContain(targetString, ";");
    }

    private static Optional<String> mayContainColon(String targetString) {
        if (Mapping.Type.hasPrefix(targetString)) {
            return Optional.empty();
        }
        return Optional.of(":");
    }

    private static Optional<String> mayContain(String targetString, String expectedCharacter) {
        return Optional.of(expectedCharacter).filter(targetString::contains);
    }
}

