/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.api;

import java.util.Optional;
import java.util.stream.Stream;
import org.apache.james.mailrepository.api.MailRepository;
import org.apache.james.mailrepository.api.MailRepositoryPath;
import org.apache.james.mailrepository.api.MailRepositoryUrl;

public interface MailRepositoryStore {
    public MailRepository select(MailRepositoryUrl var1) throws MailRepositoryStoreException;

    default public MailRepository create(MailRepositoryUrl url) throws MailRepositoryStoreException {
        return this.select(url);
    }

    public Optional<MailRepository> get(MailRepositoryUrl var1) throws MailRepositoryStoreException;

    public Stream<MailRepository> getByPath(MailRepositoryPath var1) throws MailRepositoryStoreException;

    public Stream<MailRepositoryUrl> getUrls();

    default public Stream<MailRepositoryPath> getPaths() {
        return this.getUrls().map(MailRepositoryUrl::getPath).sorted().distinct();
    }

    public static class MailRepositoryStoreException
    extends Exception {
        public MailRepositoryStoreException(String msg, Throwable t) {
            super(msg, t);
        }

        public MailRepositoryStoreException(String msg) {
            super(msg);
        }
    }
}

