/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.api;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class MailRepositoryPath
implements Comparable<MailRepositoryPath> {
    private final String value;

    public static final MailRepositoryPath fromEncoded(String encodedPath) throws UnsupportedEncodingException {
        return new MailRepositoryPath(URLDecoder.decode(encodedPath, StandardCharsets.UTF_8.displayName()));
    }

    public static final MailRepositoryPath from(String path) {
        return new MailRepositoryPath(path);
    }

    private MailRepositoryPath(String value) {
        Preconditions.checkNotNull((Object)value);
        this.value = value;
    }

    public String asString() {
        return this.value;
    }

    public String urlEncoded() throws UnsupportedEncodingException {
        return URLEncoder.encode(this.value, StandardCharsets.UTF_8.displayName());
    }

    public final boolean equals(Object o) {
        if (o instanceof MailRepositoryPath) {
            MailRepositoryPath that = (MailRepositoryPath)o;
            return Objects.equals(this.value, that.value);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).toString();
    }

    @Override
    public int compareTo(MailRepositoryPath that) {
        return this.value.compareTo(that.value);
    }
}

