/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.lmtpserver.netty;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.lmtpserver.netty.LMTPMetricsImpl;
import org.apache.james.lmtpserver.netty.LMTPServer;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.protocols.lib.handler.ProtocolHandlerLoader;
import org.apache.james.protocols.lib.netty.AbstractConfigurableAsyncServer;
import org.apache.james.protocols.lib.netty.AbstractServerFactory;
import org.jboss.netty.util.HashedWheelTimer;

public class LMTPServerFactory
extends AbstractServerFactory {
    private final ProtocolHandlerLoader loader;
    private final FileSystem fileSystem;
    protected final LMTPMetricsImpl lmtpMetrics;
    private final HashedWheelTimer hashedWheelTimer;

    @Inject
    public LMTPServerFactory(ProtocolHandlerLoader loader, FileSystem fileSystem, MetricFactory metricFactory, HashedWheelTimer hashedWheelTimer) {
        this.loader = loader;
        this.fileSystem = fileSystem;
        this.lmtpMetrics = new LMTPMetricsImpl(metricFactory);
        this.hashedWheelTimer = hashedWheelTimer;
    }

    protected LMTPServer createServer() {
        return new LMTPServer(this.lmtpMetrics);
    }

    protected List<AbstractConfigurableAsyncServer> createServers(HierarchicalConfiguration config) throws Exception {
        ArrayList<AbstractConfigurableAsyncServer> servers = new ArrayList<AbstractConfigurableAsyncServer>();
        List configs = config.configurationsAt("lmtpserver");
        for (HierarchicalConfiguration serverConfig : configs) {
            LMTPServer server = this.createServer();
            server.setFileSystem(this.fileSystem);
            server.setHashWheelTimer(this.hashedWheelTimer);
            server.setProtocolHandlerLoader(this.loader);
            server.configure(serverConfig);
            servers.add((AbstractConfigurableAsyncServer)server);
        }
        return servers;
    }
}

