/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetException;
import org.apache.mailet.base.GenericMailet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpForwardAttribute
extends GenericMailet {
    private static final Logger LOGGER = LoggerFactory.getLogger(AmqpForwardAttribute.class);
    public static final String URI_PARAMETER_NAME = "uri";
    public static final String EXCHANGE_PARAMETER_NAME = "exchange";
    public static final String ROUTING_KEY_PARAMETER_NAME = "routing_key";
    public static final String ATTRIBUTE_PARAMETER_NAME = "attribute";
    public static final String ROUTING_KEY_DEFAULT_VALUE = "";
    private String exchange;
    private String attribute;
    private ConnectionFactory connectionFactory;
    @VisibleForTesting
    String routingKey;

    public void init() throws MailetException {
        String uri = this.getInitParameter(URI_PARAMETER_NAME);
        if (Strings.isNullOrEmpty((String)uri)) {
            throw new MailetException("No value for uri parameter was provided.");
        }
        this.exchange = this.getInitParameter(EXCHANGE_PARAMETER_NAME);
        if (Strings.isNullOrEmpty((String)this.exchange)) {
            throw new MailetException("No value for exchange parameter was provided.");
        }
        this.routingKey = this.getInitParameter(ROUTING_KEY_PARAMETER_NAME, ROUTING_KEY_DEFAULT_VALUE);
        this.attribute = this.getInitParameter(ATTRIBUTE_PARAMETER_NAME);
        if (Strings.isNullOrEmpty((String)this.attribute)) {
            throw new MailetException("No value for attribute parameter was provided.");
        }
        this.connectionFactory = new ConnectionFactory();
        try {
            this.connectionFactory.setUri(uri);
        }
        catch (Exception e) {
            throw new MailetException("Invalid uri parameter was provided: " + uri, e);
        }
    }

    @VisibleForTesting
    void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void service(Mail mail) throws MailetException {
        if (mail.getAttribute(this.attribute) == null) {
            return;
        }
        Stream<byte[]> content = this.getAttributeContent(mail);
        try {
            this.sendContent(content);
        }
        catch (IOException e) {
            LOGGER.error("IOException while writing to AMQP: {}", (Object)e.getMessage(), (Object)e);
        }
        catch (TimeoutException e) {
            LOGGER.error("TimeoutException while writing to AMQP: {}", (Object)e.getMessage(), (Object)e);
        }
        catch (AlreadyClosedException e) {
            LOGGER.error("AlreadyClosedException while writing to AMQP: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private Stream<byte[]> getAttributeContent(Mail mail) throws MailetException {
        Serializable attributeContent = mail.getAttribute(this.attribute);
        if (attributeContent instanceof Map) {
            return ((Map)((Object)attributeContent)).values().stream();
        }
        if (attributeContent instanceof List) {
            return ((List)((Object)attributeContent)).stream();
        }
        if (attributeContent instanceof String) {
            return Stream.of(((String)((Object)attributeContent)).getBytes(StandardCharsets.UTF_8));
        }
        throw new MailetException("Invalid attribute found into attribute " + this.attribute + "class Map or List or String expected but " + attributeContent.getClass() + " found.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendContent(Stream<byte[]> content) throws IOException, TimeoutException {
        Connection connection = null;
        Channel channel = null;
        try {
            connection = this.connectionFactory.newConnection();
            channel = connection.createChannel();
            channel.exchangeDeclarePassive(this.exchange);
            this.sendContentOnChannel(channel, content);
        }
        finally {
            if (channel != null) {
                channel.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    private void sendContentOnChannel(Channel channel, Stream<byte[]> content) throws IOException {
        content.forEach((Consumer<byte[]>)Throwing.consumer(message -> channel.basicPublish(this.exchange, this.routingKey, new AMQP.BasicProperties(), message)));
    }

    public String getMailetInfo() {
        return "AmqpForwardAttribute";
    }
}

