/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.component.file.FileConsumer;
import org.apache.camel.component.file.FileOperations;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileExist;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.component.file.GenericFilePollingConsumer;
import org.apache.camel.component.file.GenericFileProducer;
import org.apache.camel.processor.idempotent.MemoryIdempotentRepository;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="1.0.0", scheme="file", title="File", syntax="file:directoryName", consumerClass=FileConsumer.class, label="core,file")
public class FileEndpoint
extends GenericFileEndpoint<File> {
    private static final Integer CHMOD_WRITE_MASK = 2;
    private static final Integer CHMOD_READ_MASK = 4;
    private static final Integer CHMOD_EXECUTE_MASK = 1;
    private final FileOperations operations = new FileOperations(this);
    @UriPath(name="directoryName")
    @Metadata(required="true")
    private File file;
    @UriParam(label="advanced", defaultValue="true")
    private boolean copyAndDeleteOnRenameFail = true;
    @UriParam(label="advanced")
    private boolean renameUsingCopy;
    @UriParam(label="producer,advanced", defaultValue="true")
    private boolean forceWrites = true;
    @UriParam(label="consumer,advanced")
    private boolean probeContentType;
    @UriParam(label="consumer,advanced")
    private String extendedAttributes;
    @UriParam(label="producer,advanced")
    private String chmod;
    @UriParam(label="producer,advanced")
    private String chmodDirectory;

    public FileEndpoint() {
    }

    public FileEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    @Override
    public FileConsumer createConsumer(Processor processor) throws Exception {
        String valid;
        String[] arr;
        boolean matched;
        ObjectHelper.notNull(this.operations, "operations");
        ObjectHelper.notNull(this.file, "file");
        if (!this.file.exists() && !this.file.isDirectory()) {
            if (this.isAutoCreate()) {
                this.log.debug("Creating non existing starting directory: {}", (Object)this.file);
                boolean absolute = FileUtil.isAbsolute(this.file);
                boolean created = this.operations.buildDirectory(this.file.getPath(), absolute);
                if (!created) {
                    this.log.warn("Cannot auto create starting directory: {}", (Object)this.file);
                }
            } else if (this.isStartingDirectoryMustExist()) {
                throw new FileNotFoundException("Starting directory does not exist: " + this.file);
            }
        }
        FileConsumer result = this.newFileConsumer(processor, this.operations);
        if (this.isDelete() && this.getMove() != null) {
            throw new IllegalArgumentException("You cannot set both delete=true and move options");
        }
        if (this.isNoop() && !this.isIdempotentSet()) {
            this.log.info("Endpoint is configured with noop=true so forcing endpoint to be idempotent as well");
            this.setIdempotent(true);
        }
        if (this.isIdempotentSet() && this.isIdempotent().booleanValue() && this.idempotentRepository == null) {
            this.log.info("Using default memory based idempotent repository with cache max size: {}", (Object)1000);
            this.idempotentRepository = MemoryIdempotentRepository.memoryIdempotentRepository(1000);
        }
        if (ObjectHelper.isNotEmpty(this.getReadLock()) && !(matched = Arrays.stream(arr = (valid = "none,markerFile,fileLock,rename,changed,idempotent,idempotent-changed,idempotent-rename").split(",")).anyMatch(n -> n.equals(this.getReadLock())))) {
            throw new IllegalArgumentException("ReadLock invalid: " + this.getReadLock() + ", must be one of: " + valid);
        }
        result.setMaxMessagesPerPoll(this.getMaxMessagesPerPoll());
        result.setEagerLimitMaxMessagesPerPoll(this.isEagerMaxMessagesPerPoll());
        this.configureConsumer(result);
        return result;
    }

    @Override
    public PollingConsumer createPollingConsumer() throws Exception {
        ObjectHelper.notNull(this.operations, "operations");
        ObjectHelper.notNull(this.file, "file");
        if (this.log.isDebugEnabled()) {
            this.log.debug("Creating GenericFilePollingConsumer with queueSize: {} blockWhenFull: {} blockTimeout: {}", new Object[]{this.getPollingConsumerQueueSize(), this.isPollingConsumerBlockWhenFull(), this.getPollingConsumerBlockTimeout()});
        }
        GenericFilePollingConsumer result = new GenericFilePollingConsumer(this);
        result.setBlockWhenFull(this.isPollingConsumerBlockWhenFull());
        result.setBlockTimeout(this.getPollingConsumerBlockTimeout());
        return result;
    }

    @Override
    public GenericFileProducer<File> createProducer() throws Exception {
        ObjectHelper.notNull(this.operations, "operations");
        if (this.getFileExist() == GenericFileExist.Append && (this.getTempPrefix() != null || this.getTempFileName() != null)) {
            throw new IllegalArgumentException("You cannot set both fileExist=Append and tempPrefix/tempFileName options");
        }
        if (this.getFileExist() == GenericFileExist.Move && this.getMoveExisting() == null) {
            throw new IllegalArgumentException("You must configure moveExisting option when fileExist=Move");
        }
        if (this.getMoveExisting() != null && this.getFileExist() != GenericFileExist.Move) {
            throw new IllegalArgumentException("You must configure fileExist=Move when moveExisting has been set");
        }
        return new GenericFileProducer<File>(this, this.operations);
    }

    @Override
    public Exchange createExchange(GenericFile<File> file) {
        Exchange exchange = this.createExchange();
        if (file != null) {
            file.bindToExchange(exchange, this.probeContentType);
        }
        return exchange;
    }

    protected FileConsumer newFileConsumer(Processor processor, GenericFileOperations<File> operations) {
        return new FileConsumer(this, processor, operations, this.processStrategy != null ? this.processStrategy : this.createGenericFileStrategy());
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
        this.getConfiguration().setDirectory(FileUtil.isAbsolute(file) ? file.getAbsolutePath() : file.getPath());
    }

    @Override
    public String getScheme() {
        return "file";
    }

    @Override
    protected String createEndpointUri() {
        return this.getFile().toURI().toString();
    }

    @Override
    public char getFileSeparator() {
        return File.separatorChar;
    }

    @Override
    public boolean isAbsolute(String name) {
        return FileUtil.isAbsolute(new File(name));
    }

    public boolean isCopyAndDeleteOnRenameFail() {
        return this.copyAndDeleteOnRenameFail;
    }

    public void setCopyAndDeleteOnRenameFail(boolean copyAndDeleteOnRenameFail) {
        this.copyAndDeleteOnRenameFail = copyAndDeleteOnRenameFail;
    }

    public boolean isRenameUsingCopy() {
        return this.renameUsingCopy;
    }

    public void setRenameUsingCopy(boolean renameUsingCopy) {
        this.renameUsingCopy = renameUsingCopy;
    }

    public boolean isForceWrites() {
        return this.forceWrites;
    }

    public void setForceWrites(boolean forceWrites) {
        this.forceWrites = forceWrites;
    }

    public boolean isProbeContentType() {
        return this.probeContentType;
    }

    public void setProbeContentType(boolean probeContentType) {
        this.probeContentType = probeContentType;
    }

    public String getExtendedAttributes() {
        return this.extendedAttributes;
    }

    public void setExtendedAttributes(String extendedAttributes) {
        this.extendedAttributes = extendedAttributes;
    }

    public boolean chmodPermissionsAreValid(String chmod) {
        if (chmod == null || chmod.length() < 3 || chmod.length() > 4) {
            return false;
        }
        String permissionsString = chmod.trim().substring(chmod.length() - 3);
        for (int i = 0; i < permissionsString.length(); ++i) {
            Character c = Character.valueOf(permissionsString.charAt(i));
            if (Character.isDigit(c.charValue()) && Integer.parseInt(c.toString()) <= 7) continue;
            return false;
        }
        return true;
    }

    public Set<PosixFilePermission> getPermissions() {
        HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>();
        if (ObjectHelper.isEmpty(this.chmod)) {
            return permissions;
        }
        String chmodString = this.chmod.substring(this.chmod.length() - 3);
        Integer ownerValue = Integer.parseInt(chmodString.substring(0, 1));
        Integer groupValue = Integer.parseInt(chmodString.substring(1, 2));
        Integer othersValue = Integer.parseInt(chmodString.substring(2, 3));
        if ((ownerValue & CHMOD_WRITE_MASK) > 0) {
            permissions.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((ownerValue & CHMOD_READ_MASK) > 0) {
            permissions.add(PosixFilePermission.OWNER_READ);
        }
        if ((ownerValue & CHMOD_EXECUTE_MASK) > 0) {
            permissions.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((groupValue & CHMOD_WRITE_MASK) > 0) {
            permissions.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((groupValue & CHMOD_READ_MASK) > 0) {
            permissions.add(PosixFilePermission.GROUP_READ);
        }
        if ((groupValue & CHMOD_EXECUTE_MASK) > 0) {
            permissions.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((othersValue & CHMOD_WRITE_MASK) > 0) {
            permissions.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((othersValue & CHMOD_READ_MASK) > 0) {
            permissions.add(PosixFilePermission.OTHERS_READ);
        }
        if ((othersValue & CHMOD_EXECUTE_MASK) > 0) {
            permissions.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return permissions;
    }

    public String getChmod() {
        return this.chmod;
    }

    public void setChmod(String chmod) throws Exception {
        if (!ObjectHelper.isNotEmpty(chmod) || !this.chmodPermissionsAreValid(chmod)) {
            throw new IllegalArgumentException("chmod option [" + chmod + "] is not valid");
        }
        this.chmod = chmod.trim();
    }

    public Set<PosixFilePermission> getDirectoryPermissions() {
        HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>();
        if (ObjectHelper.isEmpty(this.chmodDirectory)) {
            return permissions;
        }
        String chmodString = this.chmodDirectory.substring(this.chmodDirectory.length() - 3);
        Integer ownerValue = Integer.parseInt(chmodString.substring(0, 1));
        Integer groupValue = Integer.parseInt(chmodString.substring(1, 2));
        Integer othersValue = Integer.parseInt(chmodString.substring(2, 3));
        if ((ownerValue & CHMOD_WRITE_MASK) > 0) {
            permissions.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((ownerValue & CHMOD_READ_MASK) > 0) {
            permissions.add(PosixFilePermission.OWNER_READ);
        }
        if ((ownerValue & CHMOD_EXECUTE_MASK) > 0) {
            permissions.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((groupValue & CHMOD_WRITE_MASK) > 0) {
            permissions.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((groupValue & CHMOD_READ_MASK) > 0) {
            permissions.add(PosixFilePermission.GROUP_READ);
        }
        if ((groupValue & CHMOD_EXECUTE_MASK) > 0) {
            permissions.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((othersValue & CHMOD_WRITE_MASK) > 0) {
            permissions.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((othersValue & CHMOD_READ_MASK) > 0) {
            permissions.add(PosixFilePermission.OTHERS_READ);
        }
        if ((othersValue & CHMOD_EXECUTE_MASK) > 0) {
            permissions.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return permissions;
    }

    public String getChmodDirectory() {
        return this.chmodDirectory;
    }

    public void setChmodDirectory(String chmodDirectory) throws Exception {
        if (!ObjectHelper.isNotEmpty(chmodDirectory) || !this.chmodPermissionsAreValid(chmodDirectory)) {
            throw new IllegalArgumentException("chmodDirectory option [" + chmodDirectory + "] is not valid");
        }
        this.chmodDirectory = chmodDirectory.trim();
    }
}

