/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.managesieve.jsieve;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.james.managesieve.api.SieveParser;
import org.apache.james.managesieve.api.SyntaxException;
import org.apache.jsieve.ConfigurationManager;
import org.apache.jsieve.SieveFactory;
import org.apache.jsieve.parser.generated.ParseException;

public class Parser
implements SieveParser {
    private static final List<String> EMPTY_WARNINGS = new ArrayList<String>(0);
    private SieveFactory sieveFactory;

    public Parser() throws Exception {
        this.setConfigurationManager(new ConfigurationManager());
    }

    public Parser(ConfigurationManager manager) {
        this.setConfigurationManager(manager);
    }

    @Resource(name="jsieveconfigurationmanager")
    public void setConfigurationManager(ConfigurationManager manager) {
        this.sieveFactory = manager.build();
    }

    @Override
    public List<String> getExtensions() {
        return this.sieveFactory.getExtensions();
    }

    @Override
    public List<String> parse(String content) throws SyntaxException {
        try {
            this.sieveFactory.parse((InputStream)new ByteArrayInputStream(content.getBytes()));
        }
        catch (ParseException ex) {
            throw new SyntaxException(ex);
        }
        return EMPTY_WARNINGS;
    }
}

