/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.container.spring.lifecycle.osgi;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.james.container.spring.lifecycle.ConfigurableBeanPostProcessor;
import org.apache.james.container.spring.lifecycle.ConfigurationProvider;
import org.apache.james.container.spring.lifecycle.LogEnabledBeanPostProcessor;
import org.apache.james.container.spring.lifecycle.LogProvider;
import org.apache.james.container.spring.lifecycle.osgi.OSGIPersistenceUnitAnnotationBeanPostProcessor;
import org.apache.james.container.spring.lifecycle.osgi.OSGIResourceAnnotationBeanPostProcessor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.InitDestroyAnnotationBeanPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.osgi.extender.OsgiBeanFactoryPostProcessor;

public class OsgiLifecycleBeanFactoryPostProcessor
implements OsgiBeanFactoryPostProcessor {
    private ConfigurationProvider confProvider;
    private LogProvider logProvider;

    public void setConfigurationProvider(ConfigurationProvider confProvider) {
        this.confProvider = confProvider;
    }

    public void setLogProvider(LogProvider logProvider) {
        this.logProvider = logProvider;
    }

    public void postProcessBeanFactory(BundleContext context, ConfigurableListableBeanFactory factory) throws BeansException, InvalidSyntaxException, BundleException {
        LogEnabledBeanPostProcessor loggingProcessor = new LogEnabledBeanPostProcessor();
        loggingProcessor.setBeanFactory((BeanFactory)factory);
        loggingProcessor.setLogProvider(this.logProvider);
        loggingProcessor.setOrder(0);
        factory.addBeanPostProcessor((BeanPostProcessor)loggingProcessor);
        OSGIResourceAnnotationBeanPostProcessor resourceProcessor = new OSGIResourceAnnotationBeanPostProcessor();
        resourceProcessor.setBeanClassLoader(factory.getBeanClassLoader());
        resourceProcessor.setBeanFactory((BeanFactory)factory);
        resourceProcessor.setBundleContext(context);
        resourceProcessor.setTimeout(60000L);
        factory.addBeanPostProcessor((BeanPostProcessor)resourceProcessor);
        OSGIPersistenceUnitAnnotationBeanPostProcessor persistenceProcessor = new OSGIPersistenceUnitAnnotationBeanPostProcessor();
        persistenceProcessor.setBeanClassLoader(factory.getBeanClassLoader());
        persistenceProcessor.setBeanFactory((BeanFactory)factory);
        persistenceProcessor.setBundleContext(context);
        persistenceProcessor.setTimeout(60000L);
        factory.addBeanPostProcessor((BeanPostProcessor)persistenceProcessor);
        ConfigurableBeanPostProcessor configurationProcessor = new ConfigurableBeanPostProcessor();
        configurationProcessor.setBeanFactory((BeanFactory)factory);
        configurationProcessor.setConfigurationProvider(this.confProvider);
        configurationProcessor.setOrder(2);
        factory.addBeanPostProcessor((BeanPostProcessor)configurationProcessor);
        InitDestroyAnnotationBeanPostProcessor annotationProcessor = new InitDestroyAnnotationBeanPostProcessor();
        annotationProcessor.setInitAnnotationType(PostConstruct.class);
        annotationProcessor.setDestroyAnnotationType(PreDestroy.class);
        factory.addBeanPostProcessor((BeanPostProcessor)annotationProcessor);
    }
}

