/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.container.spring.lifecycle;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.james.container.spring.lifecycle.ConfigurationProvider;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class ConfigurationProviderImpl
implements ConfigurationProvider,
ResourceLoaderAware,
InitializingBean {
    private static final String CONFIGURATION_FILE_SUFFIX = ".xml";
    private final Map<String, HierarchicalConfiguration> configurations = new HashMap<String, HierarchicalConfiguration>();
    private Map<String, String> configurationMappings;
    private ResourceLoader loader;

    public void setConfigurationMappings(Map<String, String> configurationMappings) {
        this.configurationMappings = configurationMappings;
    }

    @Override
    public void registerConfiguration(String beanName, HierarchicalConfiguration conf) {
        this.configurations.put(beanName, conf);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.configurationMappings != null) {
            for (String key : this.configurationMappings.keySet()) {
                String value = this.configurationMappings.get(key);
                this.registerConfiguration(key, this.getConfiguration(value));
            }
        }
    }

    @Override
    public HierarchicalConfiguration getConfiguration(String name) throws ConfigurationException {
        String resourceName;
        HierarchicalConfiguration conf = this.configurations.get(name);
        if (conf != null) {
            return conf;
        }
        int i = name.indexOf(".");
        String configPart = null;
        if (i > -1) {
            resourceName = name.substring(0, i);
            configPart = name.substring(i + 1);
        } else {
            resourceName = name;
        }
        Resource resource = this.loader.getResource(this.getConfigPrefix() + resourceName + CONFIGURATION_FILE_SUFFIX);
        if (resource.exists()) {
            try {
                XMLConfiguration config = this.getConfig(resource);
                if (configPart != null) {
                    return config.configurationAt(configPart);
                }
                return config;
            }
            catch (Exception e) {
                throw new ConfigurationException("Unable to load configuration for component " + name, (Throwable)e);
            }
        }
        throw new ConfigurationException("Unable to load configuration for component " + name);
    }

    public void setResourceLoader(ResourceLoader loader) {
        this.loader = loader;
    }

    private XMLConfiguration getConfig(Resource r) throws ConfigurationException, IOException {
        XMLConfiguration config = new XMLConfiguration();
        config.setDelimiterParsingDisabled(true);
        config.setAttributeSplittingDisabled(true);
        config.load(r.getInputStream());
        return config;
    }

    private String getConfigPrefix() {
        return "classpath:";
    }
}

