/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.container.spring.filesystem;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.james.container.spring.resource.JamesResourceLoader;
import org.apache.james.filesystem.api.FileSystem;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class FileSystemImpl
implements FileSystem,
ApplicationContextAware {
    private JamesResourceLoader resourceLoader = null;

    public File getBasedir() throws FileNotFoundException {
        return new File(this.resourceLoader.getRootDirectory());
    }

    public InputStream getResource(String url) throws IOException {
        return this.resourceLoader.getResource(url).getInputStream();
    }

    public File getFile(String fileURL) throws FileNotFoundException {
        try {
            return this.resourceLoader.getResource(fileURL).getFile();
        }
        catch (IOException e) {
            throw new FileNotFoundException(e.getMessage());
        }
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.resourceLoader = (JamesResourceLoader)context;
    }
}

