/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.container.spring.bean.factorypostprocessor;

import com.google.common.collect.ImmutableSet;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.container.spring.lifecycle.ConfigurationProvider;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;

public class MailboxConfigurationBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    private static final String JPA_MAILBOXMANAGER = "jpa-mailboxmanager";
    private static final String MEMORY_MAILBOX_MANAGER = "memory-mailboxManager";
    private static final String MAILDIR_MAILBOXMANAGER = "maildir-mailboxmanager";
    private static final String CASSANDRA_MAILBOXMANAGER = "cassandra-mailboxmanager";
    private static final ImmutableSet<String> MAILBOX_MANAGER_IDS = ImmutableSet.of((Object)"jpa-mailboxmanager", (Object)"memory-mailboxManager", (Object)"maildir-mailboxmanager", (Object)"cassandra-mailboxmanager");

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        ConfigurationProvider confProvider = (ConfigurationProvider)beanFactory.getBean(ConfigurationProvider.class);
        try {
            HierarchicalConfiguration config = confProvider.getConfiguration("mailbox");
            String provider = config.getString("provider", "jpa");
            BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
            String mailbox = null;
            String subscription = null;
            String messageMapperFactory = null;
            String mailboxIdDeserializer = null;
            String mailboxIdFactory = null;
            if (provider.equalsIgnoreCase("jpa")) {
                mailbox = JPA_MAILBOXMANAGER;
                subscription = "jpa-subscriptionManager";
                messageMapperFactory = "jpa-sessionMapperFactory";
                mailboxIdDeserializer = "jpa-mailbox-id-deserializer";
                mailboxIdFactory = "jpa-mailboxIdFactory";
            } else if (provider.equalsIgnoreCase("memory")) {
                mailbox = MEMORY_MAILBOX_MANAGER;
                subscription = "memory-subscriptionManager";
                messageMapperFactory = "memory-sessionMapperFactory";
                mailboxIdDeserializer = "memory-mailbox-id-deserializer";
                mailboxIdFactory = "memory-mailboxIdFactory";
            } else if (provider.equalsIgnoreCase("maildir")) {
                mailbox = MAILDIR_MAILBOXMANAGER;
                subscription = "maildir-subscriptionManager";
                messageMapperFactory = "maildir-sessionMapperFactory";
                mailboxIdDeserializer = "maildir-mailbox-id-deserializer";
                mailboxIdFactory = "maildir-mailboxIdFactory";
            } else if (provider.equalsIgnoreCase("cassandra")) {
                mailbox = CASSANDRA_MAILBOXMANAGER;
                subscription = "cassandra-subscriptionManager";
                messageMapperFactory = "cassandra-sessionMapperFactory";
                mailboxIdDeserializer = "cassandra-mailbox-id-deserializer";
                mailboxIdFactory = "cassandra-mailboxIdFactory";
            }
            if (mailbox == null) {
                throw new ConfigurationException("Mailboxmanager provider " + provider + " not supported!");
            }
            registry.registerAlias(mailbox, "mailboxmanager");
            registry.registerAlias(subscription, "subscriptionManager");
            registry.registerAlias(messageMapperFactory, "messageMapperFactory");
            registry.registerAlias(mailboxIdDeserializer, "mailbox-id-deserializer");
            registry.registerAlias(mailboxIdFactory, "mailboxIdFactory");
            this.removeMailboxManagersExceptRightSelectedOne(registry, mailbox);
        }
        catch (ConfigurationException e) {
            throw new FatalBeanException("Unable to config the mailboxmanager", (Throwable)e);
        }
    }

    private void removeMailboxManagersExceptRightSelectedOne(BeanDefinitionRegistry registry, String selectedMailboxManager) {
        for (String mailboxManagerId : MAILBOX_MANAGER_IDS) {
            if (!this.registeredAndNotSelected(registry, selectedMailboxManager, mailboxManagerId)) continue;
            registry.removeBeanDefinition(mailboxManagerId);
        }
    }

    private boolean registeredAndNotSelected(BeanDefinitionRegistry registry, String selectedMailboxManager, String otherMailboxManager) {
        return !otherMailboxManager.equals(selectedMailboxManager) && registry.containsBeanDefinition(otherMailboxManager);
    }
}

