/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.container.spring.bean.factory.mailrepositorystore;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.CombinedConfiguration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.DefaultConfigurationBuilder;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.james.container.spring.bean.factory.AbstractBeanFactory;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.mailrepository.api.MailRepository;
import org.apache.james.mailrepository.api.MailRepositoryPath;
import org.apache.james.mailrepository.api.MailRepositoryStore;
import org.apache.james.mailrepository.api.MailRepositoryUrl;
import org.apache.james.mailrepository.api.Protocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailRepositoryStoreBeanFactory
extends AbstractBeanFactory
implements MailRepositoryStore,
Configurable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailRepositoryStoreBeanFactory.class);
    private Map<MailRepositoryUrl, MailRepository> repositories;
    private Map<Protocol, String> classes;
    private Map<Protocol, HierarchicalConfiguration> defaultConfigs;
    private HierarchicalConfiguration configuration;

    public void configure(HierarchicalConfiguration configuration) {
        this.configuration = configuration;
    }

    @PostConstruct
    public void init() throws Exception {
        LOGGER.info("JamesMailStore init...");
        this.repositories = new ReferenceMap();
        this.classes = new HashMap<Protocol, String>();
        this.defaultConfigs = new HashMap<Protocol, HierarchicalConfiguration>();
        List registeredClasses = this.configuration.configurationsAt("mailrepositories.mailrepository");
        for (HierarchicalConfiguration registeredClass : registeredClasses) {
            this.registerRepository(registeredClass);
        }
    }

    public Optional<MailRepository> get(MailRepositoryUrl url) {
        return Optional.ofNullable(this.repositories.get(url));
    }

    public Stream<MailRepository> getByPath(MailRepositoryPath path) {
        return this.repositories.keySet().stream().filter(key -> key.getPath().equals((Object)path)).map(this.repositories::get);
    }

    public synchronized void registerRepository(HierarchicalConfiguration repConf) throws ConfigurationException {
        String className = repConf.getString("[@class]");
        for (String protocol : repConf.getStringArray("protocols.protocol")) {
            SubnodeConfiguration defConf = null;
            if (repConf.getKeys("config").hasNext()) {
                defConf = repConf.configurationAt("config");
            }
            LOGGER.info("Registering Repository instance of class {} to handle {} protocol requests", (Object)className, (Object)protocol);
            if (this.classes.get(new Protocol(protocol)) != null) {
                throw new ConfigurationException("The combination of protocol and type comprise a unique key for repositories.  This constraint has been violated.  Please check your repository configuration.");
            }
            this.classes.put(new Protocol(protocol), className);
            if (defConf == null) continue;
            this.defaultConfigs.put(new Protocol(protocol), (HierarchicalConfiguration)defConf);
        }
    }

    public synchronized MailRepository select(MailRepositoryUrl destination) throws MailRepositoryStore.MailRepositoryStoreException {
        MailRepository reply = this.repositories.get(destination);
        if (reply != null) {
            LOGGER.debug("obtained repository: {},{}", (Object)destination, reply.getClass());
            return reply;
        }
        String repClass = this.classes.get(destination.getProtocol());
        LOGGER.debug("obtained repository: {} to handle: {}", (Object)repClass, (Object)destination.getProtocol().getValue());
        CombinedConfiguration config = new CombinedConfiguration();
        HierarchicalConfiguration defConf = this.defaultConfigs.get(destination.getProtocol());
        if (defConf != null) {
            config.addConfiguration((AbstractConfiguration)defConf);
        }
        DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
        builder.addProperty("[@destinationURL]", (Object)destination.asString());
        config.addConfiguration((AbstractConfiguration)builder);
        try {
            Class<?> clazz = this.getBeanFactory().getBeanClassLoader().loadClass(repClass);
            reply = (MailRepository)this.getBeanFactory().autowire(clazz, 4, false);
            if (reply instanceof Configurable) {
                ((Configurable)reply).configure((HierarchicalConfiguration)config);
            }
            reply = (MailRepository)this.getBeanFactory().initializeBean((Object)reply, destination.getProtocol().getValue());
            this.repositories.put(destination, reply);
            LOGGER.info("added repository: {}->{}", (Object)defConf, (Object)repClass);
            return reply;
        }
        catch (Exception e) {
            LOGGER.warn("Exception while creating repository: {}", (Object)e.getMessage(), (Object)e);
            throw new MailRepositoryStore.MailRepositoryStoreException("Cannot find or init repository", (Throwable)e);
        }
    }

    public synchronized Stream<MailRepositoryUrl> getUrls() {
        return this.repositories.keySet().stream();
    }
}

