/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.file;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.DefaultConfigurationBuilder;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.mailrepository.api.MailKey;
import org.apache.james.mailrepository.file.MimeMessageStreamRepositorySource;
import org.apache.james.mailrepository.lib.AbstractMailRepository;
import org.apache.james.repository.api.StreamRepository;
import org.apache.james.repository.file.FilePersistentObjectRepository;
import org.apache.james.repository.file.FilePersistentStreamRepository;
import org.apache.james.server.core.MimeMessageCopyOnWriteProxy;
import org.apache.james.server.core.MimeMessageSource;
import org.apache.james.server.core.MimeMessageWrapper;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileMailRepository
extends AbstractMailRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileMailRepository.class);
    private FilePersistentStreamRepository streamRepository;
    private FilePersistentObjectRepository objectRepository;
    private String destination;
    private Set<String> keys;
    private final Object lock = new Object();
    private boolean fifo;
    private boolean cacheKeys;
    private FileSystem fileSystem;

    @Inject
    public void setFileSystem(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    protected void doConfigure(HierarchicalConfiguration config) throws ConfigurationException {
        super.doConfigure(config);
        this.destination = config.getString("[@destinationURL]");
        LOGGER.debug("FileMailRepository.destinationURL: {}", (Object)this.destination);
        this.fifo = config.getBoolean("[@FIFO]", false);
        this.cacheKeys = config.getBoolean("[@CACHEKEYS]", true);
    }

    @PostConstruct
    public void init() throws Exception {
        try {
            DefaultConfigurationBuilder reposConfiguration = new DefaultConfigurationBuilder();
            reposConfiguration.addProperty("[@destinationURL]", (Object)this.destination);
            this.objectRepository = new FilePersistentObjectRepository();
            this.objectRepository.setFileSystem(this.fileSystem);
            this.objectRepository.configure((HierarchicalConfiguration)reposConfiguration);
            this.objectRepository.init();
            this.streamRepository = new FilePersistentStreamRepository();
            this.streamRepository.setFileSystem(this.fileSystem);
            this.streamRepository.configure((HierarchicalConfiguration)reposConfiguration);
            this.streamRepository.init();
            if (this.cacheKeys) {
                this.keys = Collections.synchronizedSet(new HashSet());
            }
            HashSet streamKeys = new HashSet();
            Iterator i = this.streamRepository.list();
            while (i.hasNext()) {
                streamKeys.add(i.next());
            }
            HashSet objectKeys = new HashSet();
            Iterator i2 = this.objectRepository.list();
            while (i2.hasNext()) {
                objectKeys.add(i2.next());
            }
            Collection strandedStreams = (Collection)streamKeys.clone();
            strandedStreams.removeAll(objectKeys);
            for (Object strandedStream : strandedStreams) {
                MailKey key = new MailKey((String)strandedStream);
                this.remove(key);
            }
            Collection strandedObjects = (Collection)objectKeys.clone();
            strandedObjects.removeAll(streamKeys);
            for (Object strandedObject : strandedObjects) {
                MailKey key = new MailKey((String)strandedObject);
                this.remove(key);
            }
            if (this.keys != null) {
                this.keys.clear();
                Iterator i3 = this.objectRepository.list();
                while (i3.hasNext()) {
                    this.keys.add((String)i3.next());
                }
            }
            LOGGER.debug("{} created in {}", (Object)((Object)((Object)this)).getClass().getName(), (Object)this.destination);
        }
        catch (Exception e) {
            LOGGER.error("Failed to retrieve Store component", (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalStore(Mail mc) throws MessagingException, IOException {
        String key = mc.getName();
        if (this.keys != null && !this.keys.contains(key)) {
            this.keys.add(key);
        }
        boolean saveStream = true;
        boolean update = true;
        MimeMessage message = mc.getMessage();
        if (message instanceof MimeMessageCopyOnWriteProxy) {
            MimeMessageCopyOnWriteProxy messageCow = (MimeMessageCopyOnWriteProxy)message;
            message = messageCow.getWrappedMessage();
        }
        if (message instanceof MimeMessageWrapper) {
            MimeMessageWrapper wrapper = (MimeMessageWrapper)message;
            String destinationBuffer = this.destination + "/" + mc.getName();
            if (destinationBuffer.equals(wrapper.getSourceId())) {
                if (!wrapper.isModified()) {
                    saveStream = false;
                }
                update = true;
            }
        }
        if (saveStream) {
            try (OutputStream out = null;){
                if (update && message instanceof MimeMessageWrapper) {
                    ((MimeMessageWrapper)message).loadMessage();
                    out = this.streamRepository.put(key);
                    ((MimeMessageWrapper)message).writeTo(out, out, null, true);
                } else {
                    out = this.streamRepository.put(key);
                    mc.getMessage().writeTo(out);
                }
            }
        }
        this.objectRepository.put(key, (Object)mc);
    }

    public Mail retrieve(MailKey key) throws MessagingException {
        try {
            Mail mc;
            try {
                mc = (Mail)this.objectRepository.get(key.asString());
            }
            catch (RuntimeException re) {
                if (re.getCause() instanceof Error) {
                    LOGGER.warn("Error when retrieving mail, not deleting: {}", (Object)re, (Object)re);
                } else {
                    LOGGER.warn("Exception retrieving mail: {}, so we're deleting it.", (Object)re, (Object)re);
                    this.remove(key);
                }
                return null;
            }
            MimeMessageStreamRepositorySource source = new MimeMessageStreamRepositorySource((StreamRepository)this.streamRepository, this.destination, key.asString());
            mc.setMessage((MimeMessage)new MimeMessageCopyOnWriteProxy((MimeMessageSource)source));
            return mc;
        }
        catch (Exception me) {
            LOGGER.error("Exception retrieving mail", (Throwable)me);
            throw new MessagingException("Exception while retrieving mail: " + me.getMessage(), me);
        }
    }

    protected void internalRemove(MailKey key) throws MessagingException {
        if (this.keys != null) {
            this.keys.remove(key.asString());
        }
        this.streamRepository.remove(key.asString());
        this.objectRepository.remove(key.asString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<MailKey> list() {
        ArrayList<Object> clone;
        if (this.keys != null) {
            Object object = this.lock;
            synchronized (object) {
                clone = new ArrayList<String>(this.keys);
            }
        } else {
            clone = new ArrayList();
            Iterator i = this.objectRepository.list();
            while (i.hasNext()) {
                clone.add(i.next());
            }
        }
        if (this.fifo) {
            Collections.sort(clone);
        }
        return clone.stream().map(MailKey::new).iterator();
    }
}

