/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailbox.tools.indexer;

import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.core.User;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.mailbox.tools.indexer.ReIndexerPerformer;
import org.apache.mailbox.tools.indexer.ReprocessingContext;

public class UserReindexingTask
implements Task {
    public static final String USER_RE_INDEXING = "userReIndexing";
    private final ReIndexerPerformer reIndexerPerformer;
    private final User user;
    private final AdditionalInformation additionalInformation;
    private final ReprocessingContext reprocessingContext;

    @Inject
    public UserReindexingTask(ReIndexerPerformer reIndexerPerformer, User user) {
        this.reIndexerPerformer = reIndexerPerformer;
        this.user = user;
        this.reprocessingContext = new ReprocessingContext();
        this.additionalInformation = new AdditionalInformation(this.reprocessingContext, user);
    }

    public Task.Result run() {
        try {
            return this.reIndexerPerformer.reIndex(this.user, this.reprocessingContext);
        }
        catch (MailboxException e) {
            return Task.Result.PARTIAL;
        }
    }

    public String type() {
        return USER_RE_INDEXING;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(this.additionalInformation);
    }

    public static class AdditionalInformation
    implements TaskExecutionDetails.AdditionalInformation {
        private final ReprocessingContext reprocessingContext;
        private final User user;

        AdditionalInformation(ReprocessingContext reprocessingContext, User user) {
            this.reprocessingContext = reprocessingContext;
            this.user = user;
        }

        public int getSuccessfullyReprocessMailCount() {
            return this.reprocessingContext.successfullyReprocessedMailCount();
        }

        public int getFailedReprocessedMailCount() {
            return this.reprocessingContext.failedReprocessingMailCount();
        }

        public String getUser() {
            return this.user.asString();
        }
    }
}

