/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailbox.tools.indexer;

import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.mailbox.tools.indexer.ReIndexerPerformer;
import org.apache.mailbox.tools.indexer.ReprocessingContext;

public class SingleMailboxReindexingTask
implements Task {
    public static final String MAILBOX_RE_INDEXING = "mailboxReIndexing";
    private final ReIndexerPerformer reIndexerPerformer;
    private final MailboxId mailboxId;
    private final AdditionalInformation additionalInformation;
    private final ReprocessingContext reprocessingContext;

    @Inject
    public SingleMailboxReindexingTask(ReIndexerPerformer reIndexerPerformer, MailboxId mailboxId) {
        this.reIndexerPerformer = reIndexerPerformer;
        this.mailboxId = mailboxId;
        this.reprocessingContext = new ReprocessingContext();
        this.additionalInformation = new AdditionalInformation(mailboxId, this.reprocessingContext);
    }

    public Task.Result run() {
        try {
            return this.reIndexerPerformer.reIndex(this.mailboxId, this.reprocessingContext);
        }
        catch (Exception e) {
            return Task.Result.PARTIAL;
        }
    }

    public String type() {
        return MAILBOX_RE_INDEXING;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(this.additionalInformation);
    }

    public static class AdditionalInformation
    implements TaskExecutionDetails.AdditionalInformation {
        private final MailboxId mailboxId;
        private final ReprocessingContext reprocessingContext;

        AdditionalInformation(MailboxId mailboxId, ReprocessingContext reprocessingContext) {
            this.mailboxId = mailboxId;
            this.reprocessingContext = reprocessingContext;
        }

        public String getMailboxId() {
            return this.mailboxId.serialize();
        }

        public int getSuccessfullyReprocessMailCount() {
            return this.reprocessingContext.successfullyReprocessedMailCount();
        }

        public int getFailedReprocessedMailCount() {
            return this.reprocessingContext.failedReprocessingMailCount();
        }
    }
}

