/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailbox.tools.indexer;

import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.mailbox.tools.indexer.ReIndexerPerformer;
import org.apache.mailbox.tools.indexer.ReprocessingContext;

public class FullReindexingTask
implements Task {
    public static final String FULL_RE_INDEXING = "FullReIndexing";
    private final ReIndexerPerformer reIndexerPerformer;
    private final AdditionalInformation additionalInformation;
    private final ReprocessingContext reprocessingContext;

    @Inject
    public FullReindexingTask(ReIndexerPerformer reIndexerPerformer) {
        this.reIndexerPerformer = reIndexerPerformer;
        this.reprocessingContext = new ReprocessingContext();
        this.additionalInformation = new AdditionalInformation(this.reprocessingContext);
    }

    public Task.Result run() {
        try {
            return this.reIndexerPerformer.reIndex(this.reprocessingContext);
        }
        catch (MailboxException e) {
            return Task.Result.PARTIAL;
        }
    }

    public String type() {
        return FULL_RE_INDEXING;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(this.additionalInformation);
    }

    public static class AdditionalInformation
    implements TaskExecutionDetails.AdditionalInformation {
        private final ReprocessingContext reprocessingContext;

        AdditionalInformation(ReprocessingContext reprocessingContext) {
            this.reprocessingContext = reprocessingContext;
        }

        public int getSuccessfullyReprocessMailCount() {
            return this.reprocessingContext.successfullyReprocessedMailCount();
        }

        public int getFailedReprocessedMailCount() {
            return this.reprocessingContext.failedReprocessingMailCount();
        }
    }
}

