/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.api;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.apache.james.mailrepository.api.MailRepositoryPath;
import org.apache.james.mailrepository.api.Protocol;

public class MailRepositoryUrl {
    private static final int PROTOCOL_PART = 0;
    private static final String PROTOCOL_SEPARATOR = "://";
    private static final int SKIP_PROTOCOL = 1;
    private final String value;
    private final MailRepositoryPath path;
    private final Protocol protocol;

    public static MailRepositoryUrl fromEncoded(String encodedUrl) throws UnsupportedEncodingException {
        return new MailRepositoryUrl(URLDecoder.decode(encodedUrl, StandardCharsets.UTF_8.displayName()));
    }

    public static MailRepositoryUrl from(String url) {
        return new MailRepositoryUrl(url);
    }

    public static MailRepositoryUrl fromPathAndProtocol(MailRepositoryPath path, String protocol) {
        return new MailRepositoryUrl(path, protocol);
    }

    private MailRepositoryUrl(String value) {
        Preconditions.checkNotNull((Object)value);
        Preconditions.checkArgument((boolean)value.contains(PROTOCOL_SEPARATOR), (Object)"The expected format is: <protocol> \"://\" <path>");
        this.value = value;
        List urlParts = Splitter.on((String)PROTOCOL_SEPARATOR).splitToList((CharSequence)value);
        this.protocol = new Protocol((String)urlParts.get(0));
        this.path = MailRepositoryPath.from(Joiner.on((String)PROTOCOL_SEPARATOR).join(Iterables.skip((Iterable)urlParts, (int)1)));
    }

    private MailRepositoryUrl(MailRepositoryPath path, String protocol) {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)protocol);
        this.path = path;
        this.protocol = new Protocol(protocol);
        this.value = protocol + PROTOCOL_SEPARATOR + path.asString();
    }

    public String asString() {
        return this.value;
    }

    public MailRepositoryPath getPath() {
        return this.path;
    }

    public String urlEncoded() throws UnsupportedEncodingException {
        return URLEncoder.encode(this.value, StandardCharsets.UTF_8.displayName());
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public final boolean equals(Object o) {
        if (o instanceof MailRepositoryUrl) {
            MailRepositoryUrl that = (MailRepositoryUrl)o;
            return Objects.equals(this.value, that.value);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).toString();
    }
}

