/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.task;

import com.github.fge.lambdas.Throwing;
import com.github.steveash.guavate.Guavate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import javax.annotation.PreDestroy;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskId;
import org.apache.james.task.TaskManager;
import org.apache.james.task.TaskNotFoundException;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.concurrent.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryTaskManager
implements TaskManager {
    private static final boolean INTERRUPT_IF_RUNNING = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(MemoryTaskManager.class);
    private final ConcurrentHashMap<TaskId, TaskExecutionDetails> idToExecutionDetails = new ConcurrentHashMap();
    private final ConcurrentHashMap<TaskId, Future<?>> idToFuture = new ConcurrentHashMap();
    private final ExecutorService executor;

    public MemoryTaskManager() {
        NamedThreadFactory threadFactory = NamedThreadFactory.withClassName(this.getClass());
        this.executor = Executors.newSingleThreadExecutor((ThreadFactory)threadFactory);
    }

    @Override
    public TaskId submit(Task task) {
        return this.submit(task, id -> {});
    }

    @VisibleForTesting
    TaskId submit(Task task, Consumer<TaskId> callback) {
        TaskId taskId = TaskId.generateTaskId();
        TaskExecutionDetails executionDetails = TaskExecutionDetails.from(task, taskId);
        this.idToExecutionDetails.put(taskId, executionDetails);
        this.idToFuture.put(taskId, this.executor.submit(() -> this.runWithMdc(executionDetails, task, callback)));
        return taskId;
    }

    private void runWithMdc(TaskExecutionDetails executionDetails, Task task, Consumer<TaskId> callback) {
        MDCBuilder.withMdc((MDCBuilder)MDCBuilder.create().addContext("taskId", (Object)executionDetails.getTaskId()).addContext("taskType", (Object)executionDetails.getType()).addContext("taskDetails", executionDetails.getAdditionalInformation()), () -> this.run(executionDetails, task, callback));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(TaskExecutionDetails executionDetails, Task task, Consumer<TaskId> callback) {
        TaskExecutionDetails started = executionDetails.start();
        this.idToExecutionDetails.put(started.getTaskId(), started);
        try {
            task.run().onComplete(() -> this.success(started)).onFailure(() -> this.failed(started, logger -> logger.info("Task was partially performed. Check logs for more details")));
        }
        catch (Exception e) {
            this.failed(started, logger -> logger.error("Error while running task", (Object)executionDetails, (Object)e));
        }
        finally {
            this.idToFuture.remove(executionDetails.getTaskId());
            callback.accept(executionDetails.getTaskId());
        }
    }

    private void success(TaskExecutionDetails started) {
        if (!this.wasCancelled(started.getTaskId())) {
            this.idToExecutionDetails.put(started.getTaskId(), started.completed());
            LOGGER.info("Task success");
        }
    }

    private void failed(TaskExecutionDetails started, Consumer<Logger> logOperation) {
        if (!this.wasCancelled(started.getTaskId())) {
            this.idToExecutionDetails.put(started.getTaskId(), started.failed());
            logOperation.accept(LOGGER);
        }
    }

    private boolean wasCancelled(TaskId taskId) {
        return this.idToExecutionDetails.get(taskId).getStatus() == TaskManager.Status.CANCELLED;
    }

    @Override
    public TaskExecutionDetails getExecutionDetails(TaskId id) {
        return Optional.ofNullable(this.idToExecutionDetails.get(id)).orElseThrow(TaskNotFoundException::new);
    }

    @Override
    public List<TaskExecutionDetails> list() {
        return ImmutableList.copyOf(this.idToExecutionDetails.values());
    }

    @Override
    public List<TaskExecutionDetails> list(TaskManager.Status status) {
        return (List)this.idToExecutionDetails.values().stream().filter(details -> details.getStatus().equals((Object)status)).collect(Guavate.toImmutableList());
    }

    @Override
    public void cancel(TaskId id) {
        Optional.ofNullable(this.idToFuture.get(id)).ifPresent(future -> {
            TaskExecutionDetails executionDetails = this.idToExecutionDetails.get(id);
            this.idToExecutionDetails.put(id, executionDetails.cancel());
            future.cancel(true);
            this.idToFuture.remove(id);
        });
    }

    @Override
    public TaskExecutionDetails await(TaskId id) {
        Optional.ofNullable(this.idToFuture.get(id)).ifPresent((Consumer<Future<?>>)Throwing.consumer(Future::get));
        return this.getExecutionDetails(id);
    }

    @PreDestroy
    public void stop() {
        this.executor.shutdownNow();
    }
}

