/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver.fastfail;

import com.github.steveash.guavate.Guavate;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.inject.Inject;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.dnsservice.api.TemporaryResolutionException;
import org.apache.james.dnsservice.library.netmatcher.NetMatcher;
import org.apache.james.protocols.api.handler.ProtocolHandler;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookReturnCode;
import org.apache.james.protocols.smtp.hook.RcptHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidRcptMX
implements RcptHook,
ProtocolHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidRcptMX.class);
    private DNSService dnsService = null;
    private NetMatcher bNetwork = null;

    public final DNSService getDNSService() {
        return this.dnsService;
    }

    @Inject
    public final void setDNSService(DNSService dnsService) {
        this.dnsService = dnsService;
    }

    public void setBannedNetworks(Collection<String> networks, DNSService dnsServer) {
        this.bNetwork = new NetMatcher(networks, dnsServer);
    }

    public HookResult doRcpt(SMTPSession session, MaybeSender sender, MailAddress rcpt) {
        Domain domain = rcpt.getDomain();
        if (!domain.equals((Object)Domain.LOCALHOST)) {
            Iterator mx;
            try {
                mx = this.dnsService.findMXRecords(domain.name()).iterator();
            }
            catch (TemporaryResolutionException e1) {
                return HookResult.DENYSOFT;
            }
            if (mx != null && mx.hasNext()) {
                while (mx.hasNext()) {
                    String mxRec = (String)mx.next();
                    try {
                        String ip = this.dnsService.getByName(mxRec).getHostAddress();
                        if (!this.bNetwork.matchInetNetwork(ip)) continue;
                        return HookResult.builder().hookReturnCode(HookReturnCode.deny()).smtpReturnCode("530").smtpDescription(DSNStatus.getStatus((int)5, (String)"7.1") + " Invalid MX " + session.getRemoteAddress().getAddress().toString() + " for domain " + domain.asString() + ". Reject email").build();
                    }
                    catch (UnknownHostException unknownHostException) {
                    }
                }
            }
        }
        return HookResult.DECLINED;
    }

    public void init(Configuration config) throws ConfigurationException {
        String[] networks = config.getStringArray("invalidMXNetworks");
        if (networks.length != 0) {
            throw new ConfigurationException("Please configure at least on invalid MX network");
        }
        Collection bannedNetworks = (Collection)Arrays.stream(networks).map(String::trim).collect(Guavate.toImmutableList());
        this.setBannedNetworks(bannedNetworks, this.dnsService);
        LOGGER.info("Invalid MX Networks: {}", (Object)this.bNetwork);
    }

    public void destroy() {
    }
}

