/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver.fastfail;

import javax.inject.Inject;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.protocols.api.handler.ProtocolHandler;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.fastfail.AbstractValidRcptHandler;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.lib.Mappings;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidRcptHandler
extends AbstractValidRcptHandler
implements ProtocolHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidRcptHandler.class);
    private final UsersRepository users;
    private final RecipientRewriteTable recipientRewriteTable;
    private final DomainList domains;
    private boolean supportsRecipientRewriteTable = true;

    @Inject
    public ValidRcptHandler(UsersRepository users, RecipientRewriteTable recipientRewriteTable, DomainList domains) {
        this.users = users;
        this.recipientRewriteTable = recipientRewriteTable;
        this.domains = domains;
    }

    public void setSupportsRecipientRewriteTable(boolean supportsRecipientRewriteTable) {
        this.supportsRecipientRewriteTable = supportsRecipientRewriteTable;
    }

    protected boolean isValidRecipient(SMTPSession session, MailAddress recipient) {
        try {
            String username = this.users.getUser(recipient);
            if (this.users.contains(username)) {
                return true;
            }
            return this.supportsRecipientRewriteTable && this.isRedirected(recipient, username);
        }
        catch (UsersRepositoryException e) {
            LOGGER.info("Unable to access UsersRepository", (Throwable)e);
            return false;
        }
    }

    private boolean isRedirected(MailAddress recipient, String username) {
        LOGGER.debug("Unknown user {} check if it's an alias", (Object)username);
        try {
            Mappings targetString = this.recipientRewriteTable.getResolvedMappings(recipient.getLocalPart(), recipient.getDomain());
            if (!targetString.isEmpty()) {
                return true;
            }
        }
        catch (RecipientRewriteTable.ErrorMappingException e) {
            return true;
        }
        catch (RecipientRewriteTableException e) {
            LOGGER.info("Unable to access RecipientRewriteTable", (Throwable)e);
            return false;
        }
        return false;
    }

    protected boolean isLocalDomain(SMTPSession session, Domain domain) {
        try {
            return this.domains.containsDomain(domain);
        }
        catch (DomainListException e) {
            LOGGER.error("Unable to get domains", (Throwable)e);
            return false;
        }
    }

    public void init(Configuration config) throws ConfigurationException {
        this.setSupportsRecipientRewriteTable(config.getBoolean("enableRecipientRewriteTable", true));
    }

    public void destroy() {
    }
}

