/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver.fastfail;

import java.io.Serializable;
import javax.inject.Inject;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.handler.ProtocolHandler;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookReturnCode;
import org.apache.james.smtpserver.JamesMessageHook;
import org.apache.james.spamassassin.SpamAssassinInvoker;
import org.apache.james.spamassassin.SpamAssassinResult;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpamAssassinHandler
implements JamesMessageHook,
ProtocolHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpamAssassinHandler.class);
    private final MetricFactory metricFactory;
    private int spamdPort = 783;
    private String spamdHost = "localhost";
    private double spamdRejectionHits = 0.0;

    @Inject
    public SpamAssassinHandler(MetricFactory metricFactory) {
        this.metricFactory = metricFactory;
    }

    public void setSpamdHost(String spamdHost) {
        this.spamdHost = spamdHost;
    }

    public void setSpamdPort(int spamdPort) {
        this.spamdPort = spamdPort;
    }

    public void setSpamdRejectionHits(double spamdRejectionHits) {
        this.spamdRejectionHits = spamdRejectionHits;
    }

    @Override
    public HookResult onMessage(SMTPSession session, Mail mail) {
        block6: {
            try {
                MimeMessage message = mail.getMessage();
                SpamAssassinInvoker sa = new SpamAssassinInvoker(this.metricFactory, this.spamdHost, this.spamdPort);
                SpamAssassinResult result = sa.scanMail(message);
                for (String key : result.getHeadersAsAttribute().keySet()) {
                    mail.setAttribute(key, (Serializable)result.getHeadersAsAttribute().get(key));
                }
                if (!(this.spamdRejectionHits > 0.0)) break block6;
                try {
                    double hits = Double.parseDouble(result.getHits());
                    if (this.spamdRejectionHits <= hits) {
                        String buffer = "Rejected message from " + session.getAttachment("SENDER_ADDRESS", ProtocolSession.State.Transaction).toString() + " from host " + session.getRemoteAddress().getHostName() + " (" + session.getRemoteAddress().getAddress().getHostAddress() + ") This message reach the spam hits treshold. Required rejection hits: " + this.spamdRejectionHits + " hits: " + hits;
                        LOGGER.info(buffer);
                        return HookResult.builder().hookReturnCode(HookReturnCode.deny()).smtpDescription(DSNStatus.getStatus((int)5, (String)"7.0") + " This message reach the spam hits treshold. Please contact the Postmaster if the email is not SPAM. Message rejected").build();
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            catch (MessagingException e) {
                LOGGER.error(e.getMessage());
            }
        }
        return HookResult.DECLINED;
    }

    public void init(Configuration config) throws ConfigurationException {
        this.setSpamdHost(config.getString("spamdHost", "localhost"));
        this.setSpamdPort(config.getInt("spamdPort", 783));
        this.setSpamdRejectionHits(config.getDouble("spamdRejectionHits", 0.0));
    }

    public void destroy() {
    }
}

