/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver.fastfail;

import java.io.Serializable;
import javax.inject.Inject;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.jspf.core.DNSService;
import org.apache.james.jspf.executor.SPFResult;
import org.apache.james.jspf.impl.DefaultSPF;
import org.apache.james.jspf.impl.SPF;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.handler.ProtocolHandler;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookReturnCode;
import org.apache.james.protocols.smtp.hook.MailHook;
import org.apache.james.protocols.smtp.hook.RcptHook;
import org.apache.james.smtpserver.JamesMessageHook;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SPFHandler
implements JamesMessageHook,
MailHook,
RcptHook,
ProtocolHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SPFHandler.class);
    private static final Logger FALLBACK_LOG = LoggerFactory.getLogger(SPFHandler.class);
    private final Logger serviceLog = FALLBACK_LOG;
    public static final String SPF_BLOCKLISTED = "SPF_BLOCKLISTED";
    public static final String SPF_DETAIL = "SPF_DETAIL";
    public static final String SPF_TEMPBLOCKLISTED = "SPF_TEMPBLOCKLISTED";
    public static final String SPF_HEADER = "SPF_HEADER";
    public static final String SPF_HEADER_MAIL_ATTRIBUTE_NAME = "org.apache.james.spf.header";
    private boolean blockSoftFail = false;
    private boolean blockPermError = true;
    private SPF spf = new DefaultSPF((org.apache.james.jspf.core.Logger)new SPFLogger(this.serviceLog));

    public void setBlockSoftFail(boolean blockSoftFail) {
        this.blockSoftFail = blockSoftFail;
    }

    public void setBlockPermError(boolean blockPermError) {
        this.blockPermError = blockPermError;
    }

    @Inject
    public void setDNSService(DNSService dnsService) {
        this.spf = new SPF(dnsService, (org.apache.james.jspf.core.Logger)new SPFLogger(this.serviceLog));
    }

    private void doSPFCheck(SMTPSession session, MaybeSender sender) {
        String heloEhlo = (String)session.getAttachment("CURRENT_HELO_NAME", ProtocolSession.State.Transaction);
        if (sender.isNullSender() || heloEhlo == null) {
            LOGGER.info("No Sender or HELO/EHLO present");
        } else {
            String ip = session.getRemoteAddress().getAddress().getHostAddress();
            SPFResult result = this.spf.checkSPF(ip, sender.asString(), heloEhlo);
            String spfResult = result.getResult();
            String explanation = "Blocked - see: " + result.getExplanation();
            session.setAttachment(SPF_HEADER, (Object)result.getHeaderText(), ProtocolSession.State.Transaction);
            LOGGER.info("Result for {} - {} - {} = {}", new Object[]{ip, sender.asString(), heloEhlo, spfResult});
            if (spfResult.equals("fail") || spfResult.equals("softfail") && this.blockSoftFail || spfResult.equals("permerror") && this.blockPermError) {
                if (spfResult.equals("permerror")) {
                    explanation = "Block caused by an invalid SPF record";
                }
                session.setAttachment(SPF_DETAIL, (Object)explanation, ProtocolSession.State.Transaction);
                session.setAttachment(SPF_BLOCKLISTED, (Object)"true", ProtocolSession.State.Transaction);
            } else if (spfResult.equals("temperror")) {
                session.setAttachment(SPF_TEMPBLOCKLISTED, (Object)"true", ProtocolSession.State.Transaction);
            }
        }
    }

    public HookResult doRcpt(SMTPSession session, MaybeSender sender, MailAddress rcpt) {
        if (!session.isRelayingAllowed()) {
            if (session.getAttachment(SPF_BLOCKLISTED, ProtocolSession.State.Transaction) != null) {
                return HookResult.builder().hookReturnCode(HookReturnCode.deny()).smtpDescription(DSNStatus.getStatus((int)5, (String)"7.1") + " " + session.getAttachment(SPF_TEMPBLOCKLISTED, ProtocolSession.State.Transaction)).build();
            }
            if (session.getAttachment(SPF_TEMPBLOCKLISTED, ProtocolSession.State.Transaction) != null) {
                return HookResult.builder().hookReturnCode(HookReturnCode.denySoft()).smtpReturnCode("451").smtpDescription(DSNStatus.getStatus((int)4, (String)"4.3") + " Temporarily rejected: Problem on SPF lookup").build();
            }
        }
        return HookResult.DECLINED;
    }

    public HookResult doMail(SMTPSession session, MaybeSender sender) {
        this.doSPFCheck(session, sender);
        return HookResult.DECLINED;
    }

    @Override
    public HookResult onMessage(SMTPSession session, Mail mail) {
        mail.setAttribute(SPF_HEADER_MAIL_ATTRIBUTE_NAME, (Serializable)((Object)((String)session.getAttachment(SPF_HEADER, ProtocolSession.State.Transaction))));
        return null;
    }

    public void init(Configuration config) throws ConfigurationException {
        this.setBlockSoftFail(config.getBoolean("blockSoftFail", false));
        this.setBlockPermError(config.getBoolean("blockPermError", true));
    }

    public void destroy() {
    }

    public static class SPFLogger
    implements org.apache.james.jspf.core.Logger {
        private final Logger serviceLog;

        public SPFLogger(Logger serviceLog) {
            this.serviceLog = serviceLog;
        }

        public SPFLogger() {
            this.serviceLog = FALLBACK_LOG;
        }

        public void debug(String message) {
            this.serviceLog.debug(message);
        }

        public void debug(String message, Throwable t) {
            this.serviceLog.debug(message, t);
        }

        public void error(String message) {
            this.serviceLog.error(message);
        }

        public void error(String message, Throwable t) {
            this.serviceLog.error(message, t);
        }

        public void fatalError(String message) {
            this.serviceLog.error(message);
        }

        public void fatalError(String message, Throwable t) {
            this.serviceLog.error(message, t);
        }

        public void info(String message) {
            this.serviceLog.info(message);
        }

        public void info(String message, Throwable t) {
            this.serviceLog.info(message, t);
        }

        public boolean isDebugEnabled() {
            return this.serviceLog.isDebugEnabled();
        }

        public boolean isErrorEnabled() {
            return this.serviceLog.isErrorEnabled();
        }

        public boolean isFatalErrorEnabled() {
            return this.serviceLog.isErrorEnabled();
        }

        public boolean isInfoEnabled() {
            return this.serviceLog.isInfoEnabled();
        }

        public boolean isWarnEnabled() {
            return this.serviceLog.isWarnEnabled();
        }

        public void warn(String message) {
            this.serviceLog.warn(message);
        }

        public void warn(String message, Throwable t) {
            this.serviceLog.warn(message, t);
        }

        public org.apache.james.jspf.core.Logger getChildLogger(String name) {
            return this;
        }
    }
}

