/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver;

import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.ConnectHandler;
import org.apache.james.protocols.lib.POP3BeforeSMTPHelper;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.util.TimeConverter;

public class POP3BeforeSMTPHandler
implements ConnectHandler<SMTPSession>,
Configurable {
    private long expireTime = 216000000L;

    public void configure(HierarchicalConfiguration config) throws ConfigurationException {
        try {
            this.setExpireTime(config.getString("expireTime", null));
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("Please configure a valid expireTime", (Throwable)e);
        }
    }

    public void setExpireTime(String rawExpireTime) {
        if (rawExpireTime != null) {
            this.expireTime = TimeConverter.getMilliSeconds((String)rawExpireTime);
        }
    }

    public Response onConnect(SMTPSession session) {
        if (Math.random() > 0.99) {
            POP3BeforeSMTPHelper.removeExpiredIP((long)this.expireTime);
        }
        if (!session.isRelayingAllowed() && POP3BeforeSMTPHelper.isAuthorized((String)session.getRemoteAddress().getAddress().getHostAddress())) {
            session.setRelayingAllowed(true);
        }
        return null;
    }

    public void init(Configuration config) throws ConfigurationException {
    }

    public void destroy() {
    }
}

