/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.ExtensibleHandler;
import org.apache.james.protocols.api.handler.LineHandler;
import org.apache.james.protocols.api.handler.WiringException;
import org.apache.james.protocols.smtp.MailEnvelope;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.AbstractHookableCmdHandler;
import org.apache.james.protocols.smtp.core.DataLineFilter;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.Hook;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookResultHook;
import org.apache.james.protocols.smtp.hook.MessageHook;
import org.apache.james.server.core.MailImpl;
import org.apache.james.server.core.MimeMessageCopyOnWriteProxy;
import org.apache.james.server.core.MimeMessageInputStream;
import org.apache.james.server.core.MimeMessageInputStreamSource;
import org.apache.james.server.core.MimeMessageSource;
import org.apache.james.smtpserver.JamesMessageHook;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataLineJamesMessageHookHandler
implements DataLineFilter,
ExtensibleHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataLineJamesMessageHookHandler.class);
    private List<JamesMessageHook> messageHandlers;
    private List<HookResultHook> rHooks;
    private List<MessageHook> mHandlers;

    public void init(Configuration config) throws ConfigurationException {
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response onLine(SMTPSession session, ByteBuffer lineByteBuffer, LineHandler<SMTPSession> next) {
        byte[] line = new byte[lineByteBuffer.remaining()];
        lineByteBuffer.get(line, 0, line.length);
        MimeMessageInputStreamSource mmiss = (MimeMessageInputStreamSource)session.getAttachment("org.apache.james.core.DataCmdHandler.DATA_MIMEMESSAGE_STREAMSOURCE", ProtocolSession.State.Transaction);
        try {
            OutputStream out = mmiss.getWritableOutputStream();
            if (line.length == 3 && line[0] == 46) {
                Response response;
                out.flush();
                out.close();
                List recipientCollection = (List)session.getAttachment("RCPT_LIST", ProtocolSession.State.Transaction);
                MaybeSender sender = (MaybeSender)session.getAttachment("SENDER_ADDRESS", ProtocolSession.State.Transaction);
                MailImpl mail = new MailImpl(MailImpl.getId(), Optional.ofNullable(sender).flatMap(MaybeSender::asOptional), (Collection)recipientCollection);
                session.setAttachment("MAIL", (Object)mail, ProtocolSession.State.Transaction);
                MimeMessageCopyOnWriteProxy mimeMessageCopyOnWriteProxy = null;
                try {
                    mimeMessageCopyOnWriteProxy = new MimeMessageCopyOnWriteProxy((MimeMessageSource)mmiss);
                    mail.setMessage((MimeMessage)mimeMessageCopyOnWriteProxy);
                    Response response2 = this.processExtensions(session, (Mail)mail);
                    session.popLineHandler();
                    response = response2;
                }
                catch (MessagingException e) {
                    SMTPResponse sMTPResponse;
                    try {
                        LOGGER.info("Unexpected error handling DATA stream", (Throwable)e);
                        sMTPResponse = new SMTPResponse("451", (CharSequence)"Unexpected error handling DATA stream.");
                    }
                    catch (Throwable throwable) {
                        LifecycleUtil.dispose(mimeMessageCopyOnWriteProxy);
                        LifecycleUtil.dispose((Object)mmiss);
                        LifecycleUtil.dispose((Object)mail);
                        throw throwable;
                    }
                    LifecycleUtil.dispose((Object)mimeMessageCopyOnWriteProxy);
                    LifecycleUtil.dispose((Object)mmiss);
                    LifecycleUtil.dispose((Object)mail);
                    return sMTPResponse;
                }
                LifecycleUtil.dispose((Object)mimeMessageCopyOnWriteProxy);
                LifecycleUtil.dispose((Object)mmiss);
                LifecycleUtil.dispose((Object)mail);
                return response;
            }
            if (line[0] == 46 && line[1] == 46) {
                out.write(line, 1, line.length - 1);
                return null;
            }
            out.write(line);
            return null;
        }
        catch (IOException e) {
            LifecycleUtil.dispose((Object)mmiss);
            SMTPResponse response = new SMTPResponse("451", (CharSequence)(DSNStatus.getStatus((int)4, (String)"0.0") + " Error processing message: " + e.getMessage()));
            LOGGER.error("Unknown error occurred while processing DATA.", (Throwable)e);
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Response processExtensions(SMTPSession session, Mail mail) {
        if (mail != null && this.messageHandlers != null) {
            try {
                Object response;
                long executionTime;
                HookResult hRes;
                long start;
                MimeMessageInputStreamSource mmiss = (MimeMessageInputStreamSource)session.getAttachment("org.apache.james.core.DataCmdHandler.DATA_MIMEMESSAGE_STREAMSOURCE", ProtocolSession.State.Transaction);
                OutputStream out = mmiss.getWritableOutputStream();
                for (MessageHook rawHandler : this.mHandlers) {
                    LOGGER.debug("executing james message handler {}", (Object)rawHandler);
                    start = System.currentTimeMillis();
                    hRes = rawHandler.onMessage(session, (MailEnvelope)new MailToMailEnvelopeWrapper(mail, out));
                    executionTime = System.currentTimeMillis() - start;
                    if (this.rHooks != null) {
                        for (HookResultHook object : this.rHooks) {
                            LOGGER.debug("executing hook {}", (Object)object);
                            hRes = object.onHookResult(session, hRes, executionTime, (Hook)rawHandler);
                        }
                    }
                    if ((response = AbstractHookableCmdHandler.calcDefaultSMTPResponse((HookResult)hRes)) == null) continue;
                    SMTPResponse sMTPResponse = response;
                    return sMTPResponse;
                }
                for (JamesMessageHook messageHandler : this.messageHandlers) {
                    LOGGER.debug("executing james message handler {}", (Object)messageHandler);
                    start = System.currentTimeMillis();
                    hRes = messageHandler.onMessage(session, mail);
                    executionTime = System.currentTimeMillis() - start;
                    if (this.rHooks != null) {
                        response = this.rHooks.iterator();
                        while (response.hasNext()) {
                            HookResultHook hookResultHook = (HookResultHook)response.next();
                            LOGGER.debug("executing hook {}", (Object)hookResultHook);
                            hRes = hookResultHook.onHookResult(session, hRes, executionTime, (Hook)messageHandler);
                        }
                    }
                    if ((response = AbstractHookableCmdHandler.calcDefaultSMTPResponse((HookResult)hRes)) == null) continue;
                    Object object = response;
                    return object;
                }
            }
            finally {
                if (mail != null) {
                    LifecycleUtil.dispose((Object)mail);
                    mail = null;
                }
                session.resetState();
            }
        }
        return null;
    }

    public void wireExtensions(Class<?> interfaceName, List<?> extension) throws WiringException {
        if (JamesMessageHook.class.equals(interfaceName)) {
            this.messageHandlers = extension;
            if (this.messageHandlers == null || this.messageHandlers.size() == 0) {
                throw new WiringException("No messageHandler configured");
            }
        } else if (MessageHook.class.equals(interfaceName)) {
            this.mHandlers = extension;
        } else if (HookResultHook.class.equals(interfaceName)) {
            this.rHooks = extension;
        }
    }

    public List<Class<?>> getMarkerInterfaces() {
        LinkedList classes = new LinkedList();
        classes.add(JamesMessageHook.class);
        classes.add(MessageHook.class);
        classes.add(HookResultHook.class);
        return classes;
    }

    protected class MailToMailEnvelopeWrapper
    implements MailEnvelope {
        private final Mail mail;
        private final OutputStream out;

        public MailToMailEnvelopeWrapper(Mail mail, OutputStream out) {
            this.mail = mail;
            this.out = out;
        }

        public InputStream getMessageInputStream() throws IOException {
            try {
                return new MimeMessageInputStream(this.mail.getMessage());
            }
            catch (MessagingException e) {
                throw new IOException("Unable to get inputstream for message", e);
            }
        }

        public OutputStream getMessageOutputStream() throws IOException {
            return this.out;
        }

        public List<MailAddress> getRecipients() {
            return ImmutableList.copyOf((Collection)this.mail.getRecipients());
        }

        public MaybeSender getMaybeSender() {
            return this.mail.getMaybeSender();
        }

        public long getSize() {
            try {
                return this.mail.getMessageSize();
            }
            catch (MessagingException e) {
                return -1L;
            }
        }
    }
}

