/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.metrics.api;

import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.james.metrics.api.Metric;
import org.apache.james.metrics.api.TimeMetric;
import reactor.core.publisher.Mono;

public interface MetricFactory {
    public Metric generate(String var1);

    public TimeMetric timer(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T> T runPublishingTimerMetric(String name, Supplier<T> operation) {
        TimeMetric timer = this.timer(name);
        try {
            T t = operation.get();
            return t;
        }
        finally {
            timer.stopAndPublish();
        }
    }

    default public <T> Mono<T> runPublishingTimerMetric(String name, Mono<T> mono) {
        TimeMetric timer = this.timer(name);
        return mono.doOnNext(ignored -> timer.stopAndPublish());
    }

    default public void runPublishingTimerMetric(String name, Runnable runnable) {
        this.runPublishingTimerMetric(name, () -> {
            runnable.run();
            return null;
        });
    }

    default public <T> CompletableFuture<T> runPublishingTimerMetric(String name, CompletableFuture<T> future) {
        TimeMetric timer = this.timer(name);
        return future.whenComplete((result, throwable) -> timer.stopAndPublish());
    }
}

