/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3.core;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.CommandHandler;
import org.apache.james.protocols.pop3.POP3Response;
import org.apache.james.protocols.pop3.POP3Session;
import org.apache.james.protocols.pop3.POP3StreamResponse;
import org.apache.james.protocols.pop3.core.CRLFTerminatedInputStream;
import org.apache.james.protocols.pop3.core.ExtraDotInputStream;
import org.apache.james.protocols.pop3.core.MessageMetaDataUtils;
import org.apache.james.protocols.pop3.mailbox.MessageMetaData;

public class RetrCmdHandler
implements CommandHandler<POP3Session> {
    private static final Collection<String> COMMANDS = ImmutableSet.of((Object)"RETR");
    @VisibleForTesting
    static final Response SYNTAX_ERROR = new POP3Response("-ERR", "Usage: RETR [mail number]").immutable();
    private static final Response ERROR_MESSAGE_RETRIEVE = new POP3Response("-ERR", "Error while retrieving message.").immutable();

    public void init(Configuration config) throws ConfigurationException {
    }

    public void destroy() {
    }

    public Response onCommand(POP3Session session, Request request) {
        POP3Response response = null;
        String parameters = request.getArgument();
        if (session.getHandlerState() == 2) {
            int num = 0;
            try {
                num = Integer.parseInt(parameters.trim());
            }
            catch (Exception e) {
                return SYNTAX_ERROR;
            }
            try {
                String uid;
                MessageMetaData data = MessageMetaDataUtils.getMetaData(session, num);
                if (data == null) {
                    StringBuilder responseBuffer = new StringBuilder(64).append("Message (").append(num).append(") does not exist.");
                    response = new POP3Response("-ERR", responseBuffer.toString());
                    return response;
                }
                List deletedUidList = (List)session.getAttachment("DELETED_UID_LIST", ProtocolSession.State.Transaction);
                if (!deletedUidList.contains(uid = data.getUid())) {
                    InputStream content = session.getUserMailbox().getMessage(uid);
                    if (content != null) {
                        CRLFTerminatedInputStream in = new CRLFTerminatedInputStream(new ExtraDotInputStream(content));
                        response = new POP3StreamResponse("+OK", "Message follows", in);
                        return response;
                    }
                    StringBuilder responseBuffer = new StringBuilder(64).append("Message (").append(num).append(") does not exist.");
                    response = new POP3Response("-ERR", responseBuffer.toString());
                }
                StringBuilder responseBuffer = new StringBuilder(64).append("Message (").append(num).append(") already deleted.");
                response = new POP3Response("-ERR", responseBuffer.toString());
            }
            catch (IOException ioe) {
                return ERROR_MESSAGE_RETRIEVE;
            }
        } else {
            return POP3Response.ERR;
        }
        return response;
    }

    public Collection<String> getImplCommands() {
        return COMMANDS;
    }
}

