/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3.core;

import java.util.List;
import java.util.stream.IntStream;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.pop3.POP3Session;
import org.apache.james.protocols.pop3.mailbox.MessageMetaData;

public class MessageMetaDataUtils {
    public static MessageMetaData getMetaData(POP3Session session, int number) {
        List uidList = (List)session.getAttachment("UID_LIST", ProtocolSession.State.Transaction);
        if (uidList == null || number > uidList.size()) {
            return null;
        }
        return (MessageMetaData)uidList.get(number - 1);
    }

    public static boolean isRFC1939Compatible(String uid) {
        if (uid == null) {
            return false;
        }
        return IntStream.range(0, uid.length()).allMatch(i -> uid.charAt(i) >= '!' && uid.charAt(i) <= '~');
    }
}

