/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3.core;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.CommandHandler;
import org.apache.james.protocols.pop3.POP3Response;
import org.apache.james.protocols.pop3.POP3Session;
import org.apache.james.protocols.pop3.core.MessageMetaDataUtils;
import org.apache.james.protocols.pop3.mailbox.MessageMetaData;

public class ListCmdHandler
implements CommandHandler<POP3Session> {
    private static final Collection<String> COMMANDS = ImmutableSet.of((Object)"LIST");

    public void init(Configuration config) throws ConfigurationException {
    }

    public void destroy() {
    }

    public Response onCommand(POP3Session session, Request request) {
        String parameters = request.getArgument();
        List uidList = (List)session.getAttachment("UID_LIST", ProtocolSession.State.Transaction);
        List deletedUidList = (List)session.getAttachment("DELETED_UID_LIST", ProtocolSession.State.Transaction);
        if (session.getHandlerState() == 2) {
            POP3Response response = null;
            if (parameters == null) {
                long size = 0L;
                int count = 0;
                ArrayList<MessageMetaData> validResults = new ArrayList<MessageMetaData>();
                if (!uidList.isEmpty()) {
                    for (MessageMetaData data : uidList) {
                        if (deletedUidList.contains(data.getUid())) continue;
                        size += data.getSize();
                        ++count;
                        validResults.add(data);
                    }
                }
                StringBuilder responseBuffer = new StringBuilder(32).append(count).append(" ").append(size);
                response = new POP3Response("+OK", responseBuffer.toString());
                count = 0;
                for (int i = 0; i < validResults.size(); ++i) {
                    responseBuffer = new StringBuilder(16).append(i + 1).append(" ").append(((MessageMetaData)validResults.get(i)).getSize());
                    response.appendLine(responseBuffer.toString());
                }
                response.appendLine(".");
            } else {
                int num = 0;
                try {
                    num = Integer.parseInt(parameters);
                    MessageMetaData data = MessageMetaDataUtils.getMetaData(session, num);
                    if (data == null) {
                        StringBuilder responseBuffer = new StringBuilder(64).append("Message (").append(num).append(") does not exist.");
                        return new POP3Response("-ERR", responseBuffer.toString());
                    }
                    if (!deletedUidList.contains(data.getUid())) {
                        StringBuilder responseBuffer = new StringBuilder(64).append(num).append(" ").append(data.getSize());
                        response = new POP3Response("+OK", responseBuffer.toString());
                    } else {
                        StringBuilder responseBuffer = new StringBuilder(64).append("Message (").append(num).append(") already deleted.");
                        response = new POP3Response("-ERR", responseBuffer.toString());
                    }
                }
                catch (IndexOutOfBoundsException npe) {
                    StringBuilder responseBuffer = new StringBuilder(64).append("Message (").append(num).append(") does not exist.");
                    response = new POP3Response("-ERR", responseBuffer.toString());
                }
                catch (NumberFormatException nfe) {
                    StringBuilder responseBuffer = new StringBuilder(64).append(parameters).append(" is not a valid number");
                    response = new POP3Response("-ERR", responseBuffer.toString());
                }
            }
            return response;
        }
        return POP3Response.ERR;
    }

    public Collection<String> getImplCommands() {
        return COMMANDS;
    }
}

