/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3.core;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.CommandHandler;
import org.apache.james.protocols.api.handler.ExtensibleHandler;
import org.apache.james.protocols.api.handler.WiringException;
import org.apache.james.protocols.pop3.POP3Response;
import org.apache.james.protocols.pop3.POP3Session;
import org.apache.james.protocols.pop3.core.CapaCapability;

public class CapaCmdHandler
implements CommandHandler<POP3Session>,
ExtensibleHandler,
CapaCapability {
    private List<CapaCapability> caps;
    private static final Collection<String> COMMANDS = ImmutableSet.of((Object)"CAPA");
    private static final Set<String> CAPS = ImmutableSet.of((Object)"PIPELINING");

    public void init(Configuration config) throws ConfigurationException {
    }

    public void destroy() {
    }

    public Response onCommand(POP3Session session, Request request) {
        POP3Response response = new POP3Response("+OK", "Capability list follows");
        for (CapaCapability capabilities : this.caps) {
            for (String cap : capabilities.getImplementedCapabilities(session)) {
                response.appendLine(cap);
            }
        }
        response.appendLine(".");
        return response;
    }

    public List<Class<?>> getMarkerInterfaces() {
        ArrayList mList = new ArrayList();
        mList.add(CapaCapability.class);
        return mList;
    }

    public void wireExtensions(Class<?> interfaceName, List<?> extension) throws WiringException {
        if (interfaceName.equals(CapaCapability.class)) {
            this.caps = extension;
        }
    }

    public Collection<String> getImplCommands() {
        return COMMANDS;
    }

    @Override
    public Set<String> getImplementedCapabilities(POP3Session session) {
        return CAPS;
    }
}

