/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.util;

import java.util.Optional;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.mailets.redirect.SpecialAddress;
import org.apache.mailet.Mail;

public class SenderUtils {
    private final Optional<MailAddress> sender;

    public static SenderUtils from(Optional<MailAddress> sender) {
        return new SenderUtils(sender);
    }

    private SenderUtils(Optional<MailAddress> sender) {
        this.sender = sender;
    }

    public Optional<MailAddress> getSender(Mail originalMail) throws MessagingException {
        if (this.sender.isPresent() && this.isUnalteredOrSender(this.sender.get())) {
            return Optional.empty();
        }
        return this.sender;
    }

    private boolean isUnalteredOrSender(MailAddress sender) {
        return sender.equals((Object)SpecialAddress.UNALTERED) || sender.equals((Object)SpecialAddress.SENDER);
    }
}

