/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.mail.Header;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.mailets.utils.MimeMessageUtils;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMatcher;

public class HasHeaderWithPrefix
extends GenericMatcher {
    private String prefix;

    public void init() throws MessagingException {
        this.prefix = this.getCondition();
        if (Strings.isNullOrEmpty((String)this.prefix)) {
            throw new MessagingException("Expecting prefix not to be empty or null with RemoveMimeHeaderByPrefix");
        }
    }

    public String getMatcherInfo() {
        return "HasHeaderWithPrefix Matcher";
    }

    public Collection<MailAddress> match(Mail mail) throws MessagingException {
        List headers = new MimeMessageUtils(mail.getMessage()).toHeaderList();
        for (Header header : headers) {
            if (!header.getName().startsWith(this.prefix)) continue;
            return mail.getRecipients();
        }
        return ImmutableList.of();
    }
}

