/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.remote.delivery;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.mail.MessagingException;
import org.apache.james.transport.mailets.remote.delivery.Repeat;
import org.apache.james.util.TimeConverter;

public class Delay {
    public static final long DEFAULT_DELAY_TIME = TimeUnit.HOURS.toMillis(6L);
    public static final int DEFAULT_ATTEMPTS = 1;
    private final int attempts;
    private final long delayTimeInMs;

    public static Delay from(String initString) throws MessagingException {
        if (Strings.isNullOrEmpty((String)initString)) {
            throw new NumberFormatException("Null or Empty strings are not permitted");
        }
        List parts = Splitter.on((char)'*').trimResults().splitToList((CharSequence)initString);
        if (parts.size() == 1) {
            return new Delay(1, TimeConverter.getMilliSeconds((String)((String)parts.get(0))));
        }
        if (parts.size() == 2) {
            int attempts = Integer.parseInt((String)parts.get(0));
            if (attempts < 0) {
                throw new MessagingException("Number of attempts negative in " + initString);
            }
            return new Delay(attempts, TimeConverter.getMilliSeconds((String)((String)parts.get(1))));
        }
        throw new MessagingException(initString + " contains too much parts");
    }

    public Delay() {
        this(1, DEFAULT_DELAY_TIME);
    }

    @VisibleForTesting
    Delay(int attempts, long delayTime) {
        this.attempts = attempts;
        this.delayTimeInMs = delayTime;
    }

    public long getDelayTimeInMs() {
        return this.delayTimeInMs;
    }

    public int getAttempts() {
        return this.attempts;
    }

    public List<Long> getExpendendDelays() {
        return Repeat.repeat(this.delayTimeInMs, this.attempts);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("attempts", this.attempts).add("delayTime", this.delayTimeInMs).toString();
    }

    public boolean equals(Object o) {
        if (o instanceof Delay) {
            Delay that = (Delay)o;
            return Objects.equal((Object)this.attempts, (Object)that.attempts) && Objects.equal((Object)this.delayTimeInMs, (Object)that.delayTimeInMs);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.attempts, this.delayTimeInMs});
    }
}

