/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.jsieve;

import java.io.Serializable;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.mailets.jsieve.ActionContext;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActionUtils.class);
    private static final String ATTRIBUTE_PREFIX = ActionUtils.class.getPackage().getName() + ".";

    public static MailAddress getSoleRecipient(Mail aMail) throws MessagingException {
        if (aMail.getRecipients() == null) {
            throw new MessagingException("Invalid number of recipients - 0. Exactly 1 recipient is expected.");
        }
        if (1 != aMail.getRecipients().size()) {
            throw new MessagingException("Invalid number of recipients - " + Integer.toString(aMail.getRecipients().size()) + ". Exactly 1 recipient is expected.");
        }
        return (MailAddress)aMail.getRecipients().iterator().next();
    }

    public static void detectAndHandleLocalLooping(Mail aMail, ActionContext context, String anAttributeSuffix) throws MessagingException {
        MailAddress thisRecipient = ActionUtils.getSoleRecipient(aMail);
        MailAddress lastRecipient = (MailAddress)aMail.getAttribute(ATTRIBUTE_PREFIX + anAttributeSuffix);
        if (null != lastRecipient && lastRecipient.equals((Object)thisRecipient)) {
            MessagingException ex = new MessagingException("This message is looping! Message ID: " + aMail.getMessage().getMessageID());
            LOGGER.warn(ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        aMail.setAttribute(ATTRIBUTE_PREFIX + anAttributeSuffix, (Serializable)thisRecipient);
    }
}

