/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.delivery;

import com.google.common.base.Preconditions;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.metrics.api.Metric;
import org.apache.james.transport.mailets.delivery.MailStore;
import org.apache.james.transport.mailets.delivery.MailboxAppender;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleMailStore
implements MailStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleMailStore.class);
    private final MailboxAppender mailboxAppender;
    private final UsersRepository usersRepository;
    private final Metric metric;
    private final String folder;

    public static Builder builder() {
        return new Builder();
    }

    private SimpleMailStore(MailboxAppender mailboxAppender, UsersRepository usersRepository, Metric metric, String folder) {
        this.mailboxAppender = mailboxAppender;
        this.usersRepository = usersRepository;
        this.metric = metric;
        this.folder = folder;
    }

    @Override
    public void storeMail(MailAddress recipient, Mail mail) throws MessagingException {
        String username = this.computeUsername(recipient);
        String locatedFolder = this.locateFolder(username, mail);
        ComposedMessageId composedMessageId = this.mailboxAppender.append(mail.getMessage(), username, locatedFolder);
        this.metric.increment();
        LOGGER.info("Local delivered mail {} successfully from {} to {} in folder {} with composedMessageId {}", new Object[]{mail.getName(), mail.getMaybeSender().asString(), recipient.asPrettyString(), locatedFolder, composedMessageId});
    }

    private String locateFolder(String username, Mail mail) {
        if (mail.getAttribute("DeliveryPath_" + username) instanceof String) {
            return (String)((Object)mail.getAttribute("DeliveryPath_" + username));
        }
        return this.folder;
    }

    private String computeUsername(MailAddress recipient) {
        try {
            return this.usersRepository.getUser(recipient);
        }
        catch (UsersRepositoryException e) {
            LOGGER.warn("Unable to retrieve username for {}", (Object)recipient.asPrettyString(), (Object)e);
            return recipient.toString();
        }
    }

    public static class Builder {
        private UsersRepository usersRepos;
        private MailboxAppender mailboxAppender;
        private String folder;
        private Metric metric;

        public Builder folder(String folder) {
            this.folder = folder;
            return this;
        }

        public Builder usersRepository(UsersRepository usersRepository) {
            this.usersRepos = usersRepository;
            return this;
        }

        public Builder mailboxAppender(MailboxAppender mailboxAppender) {
            this.mailboxAppender = mailboxAppender;
            return this;
        }

        public Builder metric(Metric metric) {
            this.metric = metric;
            return this;
        }

        public SimpleMailStore build() {
            Preconditions.checkNotNull((Object)this.usersRepos);
            Preconditions.checkNotNull((Object)this.folder);
            Preconditions.checkNotNull((Object)this.mailboxAppender);
            Preconditions.checkNotNull((Object)this.metric);
            return new SimpleMailStore(this.mailboxAppender, this.usersRepos, this.metric, this.folder);
        }
    }
}

