/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.inject.Inject;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.ParseException;
import javax.sql.DataSource;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.mailets.managesieve.ManageSieveMailet;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.model.JamesUser;
import org.apache.james.util.sql.JDBCUtil;
import org.apache.james.util.sql.SqlResources;
import org.apache.mailet.Experimental;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetContext;
import org.apache.mailet.base.DateFormats;
import org.apache.mailet.base.GenericMailet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class WhiteListManager
extends GenericMailet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManageSieveMailet.class);
    private boolean automaticInsert;
    private String displayFlag;
    private String insertFlag;
    private String removeFlag;
    private MailAddress whitelistManagerAddress;
    private String selectByPK;
    private String selectBySender;
    private String insert;
    private String deleteByPK;
    private DataSource datasource;
    private UsersRepository localusers;
    private final JDBCUtil theJDBCUtil = new JDBCUtil();
    private final SqlResources sqlQueries = new SqlResources();
    private final Map<String, String> sqlParameters = new HashMap<String, String>();

    @Inject
    public void setDataSource(DataSource datasource) {
        this.datasource = datasource;
    }

    @Inject
    public void setUsersRepository(UsersRepository localusers) {
        this.localusers = localusers;
    }

    private Map<String, String> getSqlParameters() {
        return this.sqlParameters;
    }

    public void init() throws MessagingException {
        this.automaticInsert = Boolean.valueOf(this.getInitParameter("automaticInsert"));
        LOGGER.debug("automaticInsert: {}", (Object)this.automaticInsert);
        this.displayFlag = this.getInitParameter("displayFlag");
        this.insertFlag = this.getInitParameter("insertFlag");
        this.removeFlag = this.getInitParameter("removeFlag");
        String whitelistManagerAddressString = this.getInitParameter("whitelistManagerAddress");
        if (whitelistManagerAddressString != null) {
            whitelistManagerAddressString = whitelistManagerAddressString.trim();
            LOGGER.debug("whitelistManagerAddress: {}", (Object)whitelistManagerAddressString);
            try {
                this.whitelistManagerAddress = new MailAddress(whitelistManagerAddressString);
            }
            catch (ParseException pe) {
                throw new MessagingException("Bad whitelistManagerAddress", (Exception)((Object)pe));
            }
            if (this.displayFlag != null) {
                this.displayFlag = this.displayFlag.trim();
                LOGGER.debug("displayFlag: {}", (Object)this.displayFlag);
            } else {
                LOGGER.debug("displayFlag is null");
            }
            if (this.insertFlag != null) {
                this.insertFlag = this.insertFlag.trim();
                LOGGER.debug("insertFlag: {}", (Object)this.insertFlag);
            } else {
                LOGGER.debug("insertFlag is null");
            }
            if (this.removeFlag != null) {
                this.removeFlag = this.removeFlag.trim();
                LOGGER.debug("removeFlag: {}", (Object)this.removeFlag);
            } else {
                LOGGER.debug("removeFlag is null");
            }
        } else {
            LOGGER.debug("whitelistManagerAddress is null; will ignore commands");
        }
        String repositoryPath = this.getInitParameter("repositoryPath");
        if (repositoryPath == null) {
            throw new MessagingException("repositoryPath is null");
        }
        LOGGER.debug("repositoryPath: {}", (Object)repositoryPath);
        try {
            this.initSqlQueries(this.datasource.getConnection(), this.getMailetContext());
        }
        catch (Exception e) {
            throw new MessagingException("Exception initializing queries", e);
        }
        this.selectByPK = this.sqlQueries.getSqlString("selectByPK", true);
        this.selectBySender = this.sqlQueries.getSqlString("selectBySender", true);
        this.insert = this.sqlQueries.getSqlString("insert", true);
        this.deleteByPK = this.sqlQueries.getSqlString("deleteByPK", true);
    }

    public void service(Mail mail) throws MessagingException {
        if (!mail.hasSender()) {
            return;
        }
        MailAddress senderMailAddress = mail.getMaybeSender().get();
        if (!this.getMailetContext().isLocalEmail(senderMailAddress)) {
            return;
        }
        Collection recipients = mail.getRecipients();
        if (recipients.size() == 1 && this.whitelistManagerAddress != null && this.whitelistManagerAddress.equals(recipients.toArray()[0])) {
            mail.setState("ghost");
            String subject = mail.getMessage().getSubject();
            if (this.displayFlag != null && this.displayFlag.equals(subject)) {
                this.manageDisplayRequest(mail);
            } else if (this.insertFlag != null && this.insertFlag.equals(subject)) {
                this.manageInsertRequest(mail);
            } else if (this.removeFlag != null && this.removeFlag.equals(subject)) {
                this.manageRemoveRequest(mail);
            } else {
                StringWriter sout = new StringWriter();
                PrintWriter out = new PrintWriter((Writer)sout, true);
                out.println("Answering on behalf of: " + this.whitelistManagerAddress);
                out.println("ERROR: Unknown command in the subject line: " + subject);
                this.sendReplyFromPostmaster(mail, sout.toString());
            }
            return;
        }
        if (this.automaticInsert) {
            this.checkAndInsert(senderMailAddress, recipients);
        }
    }

    public String getMailetInfo() {
        return "White List Manager mailet";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndInsert(MailAddress senderMailAddress, Collection<MailAddress> recipients) throws MessagingException {
        String senderUser = senderMailAddress.getLocalPart().toLowerCase(Locale.US);
        Domain senderHost = senderMailAddress.getDomain();
        senderUser = this.getPrimaryName(senderUser);
        Connection conn = null;
        PreparedStatement selectStmt = null;
        PreparedStatement insertStmt = null;
        boolean dbUpdated = false;
        try {
            for (MailAddress recipient : recipients) {
                Domain recipientHost;
                String recipientUser;
                ResultSet selectRS;
                block19: {
                    block18: {
                        selectRS = null;
                        try {
                            recipientUser = recipient.getLocalPart().toLowerCase(Locale.US);
                            recipientHost = recipient.getDomain();
                            if (!this.getMailetContext().isLocalServer(recipientHost)) break block18;
                        }
                        catch (Throwable throwable) {
                            this.theJDBCUtil.closeJDBCResultSet(selectRS);
                            throw throwable;
                        }
                        this.theJDBCUtil.closeJDBCResultSet(selectRS);
                        continue;
                    }
                    if (conn == null) {
                        conn = this.datasource.getConnection();
                    }
                    if (selectStmt == null) {
                        selectStmt = conn.prepareStatement(this.selectByPK);
                    }
                    selectStmt.setString(1, senderUser);
                    selectStmt.setString(2, senderHost.asString());
                    selectStmt.setString(3, recipientUser);
                    selectStmt.setString(4, recipientHost.asString());
                    selectRS = selectStmt.executeQuery();
                    if (!selectRS.next()) break block19;
                    this.theJDBCUtil.closeJDBCResultSet(selectRS);
                    continue;
                }
                if (insertStmt == null) {
                    insertStmt = conn.prepareStatement(this.insert);
                }
                insertStmt.setString(1, senderUser);
                insertStmt.setString(2, senderHost.asString());
                insertStmt.setString(3, recipientUser);
                insertStmt.setString(4, recipientHost.asString());
                insertStmt.executeUpdate();
                dbUpdated = true;
                this.theJDBCUtil.closeJDBCResultSet(selectRS);
                if (conn == null || !dbUpdated || conn.getAutoCommit()) continue;
                conn.commit();
                dbUpdated = false;
            }
        }
        catch (SQLException sqle) {
            LOGGER.error("Error accessing database", (Throwable)sqle);
            throw new MessagingException("Exception thrown", (Exception)sqle);
        }
        finally {
            this.theJDBCUtil.closeJDBCStatement(selectStmt);
            this.theJDBCUtil.closeJDBCStatement(insertStmt);
            try {
                if (conn != null && dbUpdated && !conn.getAutoCommit()) {
                    conn.rollback();
                    dbUpdated = false;
                }
            }
            catch (Exception e) {
                LOGGER.error("Ignored exception upon rollback", (Throwable)e);
            }
            this.theJDBCUtil.closeJDBCConnection(conn);
        }
    }

    private void manageDisplayRequest(Mail mail) throws MessagingException {
        MailAddress senderMailAddress = mail.getMaybeSender().get();
        String senderUser = senderMailAddress.getLocalPart().toLowerCase(Locale.US);
        Domain senderHost = senderMailAddress.getDomain();
        senderUser = this.getPrimaryName(senderUser);
        Connection conn = null;
        PreparedStatement selectStmt = null;
        ResultSet selectRS = null;
        StringWriter sout = new StringWriter();
        PrintWriter out = new PrintWriter((Writer)sout, true);
        try {
            out.println("Answering on behalf of: " + this.whitelistManagerAddress);
            out.println("Displaying white list of " + new MailAddress(senderUser, senderHost) + ":");
            out.println();
            conn = this.datasource.getConnection();
            selectStmt = conn.prepareStatement(this.selectBySender);
            selectStmt.setString(1, senderUser);
            selectStmt.setString(2, senderHost.asString());
            selectRS = selectStmt.executeQuery();
            while (selectRS.next()) {
                MailAddress mailAddress = new MailAddress(selectRS.getString(1), selectRS.getString(2));
                out.println(mailAddress.toInternetAddress().toString());
            }
            out.println();
            out.println("Finished");
            this.sendReplyFromPostmaster(mail, sout.toString());
        }
        catch (SQLException sqle) {
            try {
                out.println("Error accessing the database");
                this.sendReplyFromPostmaster(mail, sout.toString());
                throw new MessagingException("Error accessing database", (Exception)sqle);
            }
            catch (Throwable throwable) {
                this.theJDBCUtil.closeJDBCResultSet(selectRS);
                this.theJDBCUtil.closeJDBCStatement(selectStmt);
                this.theJDBCUtil.closeJDBCConnection(conn);
                throw throwable;
            }
        }
        this.theJDBCUtil.closeJDBCResultSet(selectRS);
        this.theJDBCUtil.closeJDBCStatement((Statement)selectStmt);
        this.theJDBCUtil.closeJDBCConnection(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void manageInsertRequest(Mail mail) throws MessagingException {
        MailAddress senderMailAddress = mail.getMaybeSender().get();
        String senderUser = senderMailAddress.getLocalPart().toLowerCase(Locale.US);
        Domain senderHost = senderMailAddress.getDomain();
        senderUser = this.getPrimaryName(senderUser);
        Connection conn = null;
        PreparedStatement selectStmt = null;
        PreparedStatement insertStmt = null;
        boolean dbUpdated = false;
        StringWriter sout = new StringWriter();
        PrintWriter out = new PrintWriter((Writer)sout, true);
        try {
            out.println("Answering on behalf of: " + this.whitelistManagerAddress);
            out.println("Inserting in the white list of " + new MailAddress(senderUser, senderHost) + " ...");
            out.println();
            MimeMessage message = mail.getMessage();
            Object content = message.getContent();
            if (message.getContentType().startsWith("text/plain") && content instanceof String) {
                StringTokenizer st = new StringTokenizer((String)content, " \t\n\r\f,;:<>");
                while (st.hasMoreTokens()) {
                    Domain recipientHost;
                    String recipientUser;
                    MailAddress recipientMailAddress;
                    ResultSet selectRS;
                    block27: {
                        block26: {
                            selectRS = null;
                            try {
                                try {
                                    recipientMailAddress = new MailAddress(st.nextToken());
                                }
                                catch (ParseException pe) {
                                    this.theJDBCUtil.closeJDBCResultSet(selectRS);
                                    continue;
                                }
                            }
                            catch (Throwable throwable) {
                                this.theJDBCUtil.closeJDBCResultSet(selectRS);
                                throw throwable;
                            }
                            recipientUser = recipientMailAddress.getLocalPart().toLowerCase(Locale.US);
                            recipientHost = recipientMailAddress.getDomain();
                            if (!this.getMailetContext().isLocalServer(recipientHost)) break block26;
                            this.theJDBCUtil.closeJDBCResultSet(selectRS);
                            continue;
                        }
                        if (conn == null) {
                            conn = this.datasource.getConnection();
                        }
                        if (selectStmt == null) {
                            selectStmt = conn.prepareStatement(this.selectByPK);
                        }
                        selectStmt.setString(1, senderUser);
                        selectStmt.setString(2, senderHost.asString());
                        selectStmt.setString(3, recipientUser);
                        selectStmt.setString(4, recipientHost.asString());
                        selectRS = selectStmt.executeQuery();
                        if (!selectRS.next()) break block27;
                        out.println("Skipped:  " + recipientMailAddress);
                        this.theJDBCUtil.closeJDBCResultSet(selectRS);
                        continue;
                    }
                    if (insertStmt == null) {
                        insertStmt = conn.prepareStatement(this.insert);
                    }
                    insertStmt.setString(1, senderUser);
                    insertStmt.setString(2, senderHost.asString());
                    insertStmt.setString(3, recipientUser);
                    insertStmt.setString(4, recipientHost.asString());
                    insertStmt.executeUpdate();
                    dbUpdated = true;
                    out.println("Inserted: " + recipientMailAddress);
                    this.theJDBCUtil.closeJDBCResultSet(selectRS);
                }
                if (dbUpdated) {
                    LOGGER.debug("Insertion request issued by {}", (Object)senderMailAddress);
                }
                if (conn != null && dbUpdated && !conn.getAutoCommit()) {
                    conn.commit();
                    dbUpdated = false;
                }
            } else {
                out.println("The message must be plain - no action");
            }
            out.println();
            out.println("Finished");
            this.sendReplyFromPostmaster(mail, sout.toString());
        }
        catch (SQLException sqle) {
            out.println("Error accessing the database");
            this.sendReplyFromPostmaster(mail, sout.toString());
            throw new MessagingException("Error accessing the database", (Exception)sqle);
        }
        catch (IOException ioe) {
            out.println("Error getting message content");
            this.sendReplyFromPostmaster(mail, sout.toString());
            throw new MessagingException("Error getting message content", (Exception)ioe);
        }
        finally {
            this.theJDBCUtil.closeJDBCStatement(selectStmt);
            this.theJDBCUtil.closeJDBCStatement(insertStmt);
            try {
                if (conn != null && dbUpdated && !conn.getAutoCommit()) {
                    conn.rollback();
                    dbUpdated = false;
                }
            }
            catch (Exception e) {
                LOGGER.error("Ignored exception upon rollback", (Throwable)e);
            }
            this.theJDBCUtil.closeJDBCConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void manageRemoveRequest(Mail mail) throws MessagingException {
        MailAddress senderMailAddress = mail.getMaybeSender().get();
        String senderUser = senderMailAddress.getLocalPart().toLowerCase(Locale.US);
        Domain senderHost = senderMailAddress.getDomain();
        senderUser = this.getPrimaryName(senderUser);
        Connection conn = null;
        PreparedStatement selectStmt = null;
        PreparedStatement deleteStmt = null;
        boolean dbUpdated = false;
        StringWriter sout = new StringWriter();
        PrintWriter out = new PrintWriter((Writer)sout, true);
        try {
            out.println("Answering on behalf of: " + this.whitelistManagerAddress);
            out.println("Removing from the white list of " + new MailAddress(senderUser, senderHost) + " ...");
            out.println();
            MimeMessage message = mail.getMessage();
            Object content = message.getContent();
            if (message.getContentType().startsWith("text/plain") && content instanceof String) {
                StringTokenizer st = new StringTokenizer((String)content, " \t\n\r\f,;:<>");
                while (st.hasMoreTokens()) {
                    Domain recipientHost;
                    String recipientUser;
                    MailAddress recipientMailAddress;
                    ResultSet selectRS;
                    block27: {
                        block26: {
                            selectRS = null;
                            try {
                                try {
                                    recipientMailAddress = new MailAddress(st.nextToken());
                                }
                                catch (ParseException pe) {
                                    this.theJDBCUtil.closeJDBCResultSet(selectRS);
                                    continue;
                                }
                            }
                            catch (Throwable throwable) {
                                this.theJDBCUtil.closeJDBCResultSet(selectRS);
                                throw throwable;
                            }
                            recipientUser = recipientMailAddress.getLocalPart().toLowerCase(Locale.US);
                            recipientHost = recipientMailAddress.getDomain();
                            if (!this.getMailetContext().isLocalServer(recipientHost)) break block26;
                            this.theJDBCUtil.closeJDBCResultSet(selectRS);
                            continue;
                        }
                        if (conn == null) {
                            conn = this.datasource.getConnection();
                        }
                        if (selectStmt == null) {
                            selectStmt = conn.prepareStatement(this.selectByPK);
                        }
                        selectStmt.setString(1, senderUser);
                        selectStmt.setString(2, senderHost.asString());
                        selectStmt.setString(3, recipientUser);
                        selectStmt.setString(4, recipientHost.asString());
                        selectRS = selectStmt.executeQuery();
                        if (selectRS.next()) break block27;
                        out.println("Skipped: " + recipientMailAddress);
                        this.theJDBCUtil.closeJDBCResultSet(selectRS);
                        continue;
                    }
                    if (deleteStmt == null) {
                        deleteStmt = conn.prepareStatement(this.deleteByPK);
                    }
                    deleteStmt.setString(1, senderUser);
                    deleteStmt.setString(2, senderHost.asString());
                    deleteStmt.setString(3, recipientUser);
                    deleteStmt.setString(4, recipientHost.asString());
                    deleteStmt.executeUpdate();
                    dbUpdated = true;
                    out.println("Removed: " + recipientMailAddress);
                    this.theJDBCUtil.closeJDBCResultSet(selectRS);
                }
                if (dbUpdated) {
                    LOGGER.debug("Removal request issued by {}", (Object)senderMailAddress);
                }
                if (conn != null && dbUpdated && !conn.getAutoCommit()) {
                    conn.commit();
                    dbUpdated = false;
                }
            } else {
                out.println("The message must be plain - no action");
            }
            out.println();
            out.println("Finished");
            this.sendReplyFromPostmaster(mail, sout.toString());
        }
        catch (SQLException sqle) {
            out.println("Error accessing the database");
            this.sendReplyFromPostmaster(mail, sout.toString());
            throw new MessagingException("Error accessing the database", (Exception)sqle);
        }
        catch (IOException ioe) {
            out.println("Error getting message content");
            this.sendReplyFromPostmaster(mail, sout.toString());
            throw new MessagingException("Error getting message content", (Exception)ioe);
        }
        finally {
            this.theJDBCUtil.closeJDBCStatement(selectStmt);
            this.theJDBCUtil.closeJDBCStatement(deleteStmt);
            try {
                if (conn != null && dbUpdated && !conn.getAutoCommit()) {
                    conn.rollback();
                    dbUpdated = false;
                }
            }
            catch (Exception e) {
                LOGGER.error("Ignored exception upon rollback", (Throwable)e);
            }
            this.theJDBCUtil.closeJDBCConnection(conn);
        }
    }

    private void sendReplyFromPostmaster(Mail mail, String stringContent) {
        try {
            String subject;
            MailAddress notifier = this.getMailetContext().getPostmaster();
            MailAddress senderMailAddress = mail.getMaybeSender().get();
            MimeMessage message = mail.getMessage();
            MimeMessage reply = new MimeMessage(Session.getDefaultInstance((Properties)System.getProperties(), null));
            InternetAddress[] rcptAddr = new InternetAddress[]{senderMailAddress.toInternetAddress()};
            reply.setRecipients(Message.RecipientType.TO, (Address[])rcptAddr);
            reply.setFrom((Address)notifier.toInternetAddress());
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart part = new MimeBodyPart();
            part.setContent((Object)stringContent, "text/plain");
            part.setHeader("Content-Type", "text/plain");
            multipart.addBodyPart((BodyPart)part);
            reply.setContent((Multipart)multipart);
            reply.setHeader("Content-Type", multipart.getContentType());
            HashSet<MailAddress> recipients = new HashSet<MailAddress>();
            recipients.add(senderMailAddress);
            if (reply.getHeader("Date") == null) {
                reply.setHeader("Date", DateFormats.RFC822_DATE_FORMAT.format(new Date()));
            }
            if ((subject = message.getSubject()) == null) {
                subject = "";
            }
            if (subject.indexOf("Re:") == 0) {
                reply.setSubject(subject);
            } else {
                reply.setSubject("Re:" + subject);
            }
            reply.setHeader("In-Reply-To", message.getMessageID());
            this.getMailetContext().sendMail(notifier, recipients, reply);
        }
        catch (Exception e) {
            LOGGER.error("Exception found sending reply", (Throwable)e);
        }
    }

    private String getPrimaryName(String originalUsername) {
        String username;
        try {
            username = originalUsername;
            JamesUser user = (JamesUser)this.localusers.getUserByName(username);
            if (user.getAliasing()) {
                username = user.getAlias();
            }
        }
        catch (Exception e) {
            username = originalUsername;
        }
        return username;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSqlQueries(Connection conn, MailetContext mailetContext) throws Exception {
        try {
            if (conn.getAutoCommit()) {
                conn.setAutoCommit(false);
            }
            File sqlFile = new File((String)mailetContext.getAttribute("confDir"), "sqlResources.xml").getCanonicalFile();
            this.sqlQueries.init(sqlFile, "WhiteList", conn, this.getSqlParameters());
            this.checkTables(conn);
        }
        finally {
            this.theJDBCUtil.closeJDBCConnection(conn);
        }
    }

    private void checkTables(Connection conn) throws SQLException {
        boolean dbUpdated = this.createTable(conn, "whiteListTableName", "createWhiteListTable");
        if (conn != null && dbUpdated && !conn.getAutoCommit()) {
            conn.commit();
            dbUpdated = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createTable(Connection conn, String tableNameSqlStringName, String createSqlStringName) throws SQLException {
        String tableName = this.sqlQueries.getSqlString(tableNameSqlStringName, true);
        DatabaseMetaData dbMetaData = conn.getMetaData();
        if (this.theJDBCUtil.tableExists(dbMetaData, tableName)) {
            return false;
        }
        PreparedStatement createStatement = null;
        try {
            createStatement = conn.prepareStatement(this.sqlQueries.getSqlString(createSqlStringName, true));
            createStatement.execute();
            LOGGER.info("Created table '{}' using sqlResources string '{}'.", (Object)tableName, (Object)createSqlStringName);
        }
        catch (Throwable throwable) {
            this.theJDBCUtil.closeJDBCStatement(createStatement);
            throw throwable;
        }
        this.theJDBCUtil.closeJDBCStatement((Statement)createStatement);
        return true;
    }
}

