/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.apache.mailet.Experimental;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class SerialiseToHTTP
extends GenericMailet {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerialiseToHTTP.class);
    private String url;
    private String parameterKey = null;
    private String parameterValue = null;
    private String messageKeyName = "message";
    private boolean passThrough = true;

    public void init() throws MessagingException {
        this.passThrough = this.getInitParameter("passThrough", "true").compareToIgnoreCase("true") == 0;
        String targetUrl = this.getInitParameter("url");
        this.parameterKey = this.getInitParameter("parameterKey");
        this.parameterValue = this.getInitParameter("parameterValue");
        String m = this.getInitParameter("MessageKeyName");
        if (m != null) {
            this.messageKeyName = m;
        }
        if (targetUrl == null || targetUrl.equals("")) {
            throw new MessagingException("Please configure a targetUrl (\"url\")");
        }
        try {
            this.url = new URL(targetUrl).toExternalForm();
        }
        catch (MalformedURLException e) {
            throw new MessagingException("Unable to contruct URL object from url");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("I will attempt to deliver serialised messages to " + targetUrl + " as " + this.messageKeyName + ". " + (this.parameterKey == null || this.parameterKey.length() < 2 ? "I will not add any fields to the post. " : "I will prepend: " + this.parameterKey + "=" + this.parameterValue + ". ") + (this.passThrough ? "Messages will pass through." : "Messages will be ghosted."));
        }
    }

    public void service(Mail mail) {
        try {
            MimeMessage message = mail.getMessage();
            String serialisedMessage = this.getSerialisedMessage(message);
            NameValuePair[] nameValuePairs = this.getNameValuePairs(serialisedMessage);
            String result = this.httpPost(nameValuePairs);
            if (this.passThrough) {
                this.addHeader(mail, result == null || result.length() == 0, result);
            } else {
                mail.setState("ghost");
            }
        }
        catch (IOException | MessagingException me) {
            LOGGER.error("Messaging exception", me);
            this.addHeader(mail, false, me.getMessage());
        }
    }

    private void addHeader(Mail mail, boolean success, String errorMessage) {
        try {
            MimeMessage message = mail.getMessage();
            message.setHeader("X-toHTTP", success ? "Succeeded" : "Failed");
            if (!success && errorMessage != null && errorMessage.length() > 0) {
                message.setHeader("X-toHTTPFailure", errorMessage);
            }
            message.saveChanges();
        }
        catch (MessagingException me) {
            LOGGER.error("Messaging exception", (Throwable)me);
        }
    }

    private String getSerialisedMessage(MimeMessage message) throws IOException, MessagingException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        message.writeTo((OutputStream)os);
        return os.toString();
    }

    /*
     * Exception decompiling
     */
    private String httpPost(NameValuePair[] data) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private NameValuePair[] getNameValuePairs(String message) throws UnsupportedEncodingException {
        int l = 1;
        if (this.parameterKey != null && this.parameterKey.length() > 0) {
            l = 2;
        }
        BasicNameValuePair[] data = new BasicNameValuePair[l];
        data[0] = new BasicNameValuePair(this.messageKeyName, message);
        if (l == 2) {
            data[1] = new BasicNameValuePair(this.parameterKey, this.parameterValue);
        }
        return data;
    }

    public String getMailetInfo() {
        return "HTTP POST serialised message";
    }
}

