/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.io.Serializable;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.jspf.core.Logger;
import org.apache.james.jspf.executor.SPFResult;
import org.apache.james.jspf.impl.DefaultSPF;
import org.apache.james.transport.mailets.managesieve.ManageSieveMailet;
import org.apache.mailet.Experimental;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;
import org.slf4j.LoggerFactory;

@Experimental
public class SPF
extends GenericMailet {
    private static final org.slf4j.Logger LOGGER = LoggerFactory.getLogger(ManageSieveMailet.class);
    private boolean addHeader = false;
    private org.apache.james.jspf.impl.SPF spf;
    public static final String EXPLANATION_ATTRIBUTE = "org.apache.james.transport.mailets.spf.explanation";
    public static final String RESULT_ATTRIBUTE = "org.apache.james.transport.mailets.spf.result";

    public void init() {
        this.addHeader = Boolean.valueOf(this.getInitParameter("addHeader", "false"));
        SPFLoggerAdapter logger = new SPFLoggerAdapter(Boolean.valueOf(this.getInitParameter("debug", "false")));
        this.spf = new DefaultSPF((Logger)logger);
    }

    public void service(Mail mail) throws MessagingException {
        String remoteAddr = mail.getRemoteAddr();
        String helo = mail.getRemoteHost();
        if (!remoteAddr.equals("127.0.0.1")) {
            String sender = mail.getMaybeSender().asString("");
            SPFResult result = this.spf.checkSPF(remoteAddr, sender, helo);
            mail.setAttribute(EXPLANATION_ATTRIBUTE, (Serializable)((Object)result.getExplanation()));
            mail.setAttribute(RESULT_ATTRIBUTE, (Serializable)((Object)result.getResult()));
            LOGGER.debug("ip:{} from:{} helo:{} = {}", new Object[]{remoteAddr, sender, helo, result.getResult()});
            if (this.addHeader) {
                try {
                    MimeMessage msg = mail.getMessage();
                    msg.addHeader(result.getHeaderName(), result.getHeaderText());
                    msg.saveChanges();
                }
                catch (MessagingException messagingException) {
                    // empty catch block
                }
            }
        }
    }

    private class SPFLoggerAdapter
    implements Logger {
        private boolean debug = false;
        private String name = "SPFLogger";

        public SPFLoggerAdapter(boolean debug) {
            this.debug = debug;
        }

        public SPFLoggerAdapter(String name, boolean debug) {
            this.name = name;
            this.debug = debug;
        }

        public void debug(String arg0) {
            if (this.debug) {
                LOGGER.debug(arg0);
            }
        }

        public void debug(String arg0, Throwable arg1) {
            if (this.debug) {
                LOGGER.debug(arg0, arg1);
            }
        }

        public void error(String arg0) {
            LOGGER.error(arg0);
        }

        public void error(String arg0, Throwable arg1) {
            LOGGER.error(arg0, arg1);
        }

        public void fatalError(String arg0) {
            LOGGER.error(arg0);
        }

        public void fatalError(String arg0, Throwable arg1) {
            LOGGER.error(arg0, arg1);
        }

        public Logger getChildLogger(String childName) {
            return new SPFLoggerAdapter(this.name + "." + childName, this.debug);
        }

        public void info(String arg0) {
            LOGGER.info(arg0);
        }

        public void info(String arg0, Throwable arg1) {
            LOGGER.info(arg0, arg1);
        }

        public boolean isDebugEnabled() {
            return LOGGER.isDebugEnabled();
        }

        public boolean isErrorEnabled() {
            return LOGGER.isErrorEnabled();
        }

        public boolean isFatalErrorEnabled() {
            return LOGGER.isErrorEnabled();
        }

        public boolean isInfoEnabled() {
            return LOGGER.isInfoEnabled();
        }

        public boolean isWarnEnabled() {
            return LOGGER.isWarnEnabled();
        }

        public void warn(String arg0) {
            LOGGER.warn(arg0);
        }

        public void warn(String arg0, Throwable arg1) {
            LOGGER.warn(arg0, arg1);
        }
    }
}

