/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import org.apache.james.core.MailAddress;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.transport.mailets.redirect.AddressExtractor;
import org.apache.james.transport.mailets.redirect.InitParameters;
import org.apache.james.transport.mailets.redirect.ProcessRedirectNotify;
import org.apache.james.transport.mailets.redirect.RedirectMailetInitParameters;
import org.apache.james.transport.mailets.redirect.RedirectNotify;
import org.apache.james.transport.mailets.utils.MimeMessageModifier;
import org.apache.james.transport.mailets.utils.MimeMessageUtils;
import org.apache.james.transport.util.MailAddressUtils;
import org.apache.james.transport.util.RecipientsUtils;
import org.apache.james.transport.util.ReplyToUtils;
import org.apache.james.transport.util.SenderUtils;
import org.apache.james.transport.util.SpecialAddressesUtils;
import org.apache.james.transport.util.TosUtils;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Resend
extends GenericMailet
implements RedirectNotify {
    private static final Logger LOGGER = LoggerFactory.getLogger(Resend.class);
    private static final String[] CONFIGURABLE_PARAMETERS = new String[]{"debug", "passThrough", "fakeDomainCheck", "inline", "attachment", "message", "recipients", "to", "replyTo", "replyto", "reversePath", "sender", "subject", "prefix", "attachError", "isReply"};
    private final DNSService dns;

    @Inject
    public Resend(DNSService dns) {
        this.dns = dns;
    }

    public String getMailetInfo() {
        return "Redirect Mailet";
    }

    @Override
    public InitParameters getInitParameters() {
        return RedirectMailetInitParameters.from(this);
    }

    @Override
    public String[] getAllowedInitParameters() {
        return CONFIGURABLE_PARAMETERS;
    }

    @Override
    public DNSService getDNSService() {
        return this.dns;
    }

    public void init() throws MessagingException {
        if (this.getInitParameters().isDebug()) {
            LOGGER.debug("Initializing");
        }
        this.checkInitParameters(this.getAllowedInitParameters());
        if (this.getInitParameters().isStatic() && this.getInitParameters().isDebug()) {
            LOGGER.debug(this.getInitParameters().asString());
        }
    }

    @Override
    public String getMessage(Mail originalMail) throws MessagingException {
        return this.getInitParameters().getMessage();
    }

    @Override
    public List<InternetAddress> getTo() throws MessagingException {
        return MailAddressUtils.toInternetAddresses(AddressExtractor.withContext(this.getMailetContext()).allowedSpecials((List<String>)ImmutableList.of((Object)"postmaster", (Object)"sender", (Object)"from", (Object)"replyTo", (Object)"reversePath", (Object)"unaltered", (Object)"recipients", (Object)"to", (Object)"null")).extract(this.getInitParameters().getTo()));
    }

    @Override
    public List<MailAddress> getTo(Mail originalMail) throws MessagingException {
        return TosUtils.from(this).getTo(originalMail);
    }

    @Override
    public Optional<MailAddress> getReplyTo() throws MessagingException {
        Optional<String> replyTo = this.getInitParameters().getReplyTo();
        if (!replyTo.isPresent()) {
            return Optional.empty();
        }
        return AddressExtractor.withContext(this.getMailetContext()).allowedSpecials((List<String>)ImmutableList.of((Object)"postmaster", (Object)"sender", (Object)"null", (Object)"unaltered")).extract(replyTo).stream().findFirst();
    }

    @Override
    public Optional<MailAddress> getReplyTo(Mail originalMail) throws MessagingException {
        return ReplyToUtils.from(this.getReplyTo()).getReplyTo(originalMail);
    }

    @Override
    public List<MailAddress> getRecipients() throws MessagingException {
        ImmutableList.Builder builder = ImmutableList.builder();
        List<MailAddress> mailAddresses = AddressExtractor.withContext(this.getMailetContext()).allowedSpecials((List<String>)ImmutableList.of((Object)"postmaster", (Object)"sender", (Object)"from", (Object)"replyTo", (Object)"reversePath", (Object)"unaltered", (Object)"recipients", (Object)"to", (Object)"null")).extract(this.getInitParameters().getRecipients());
        for (MailAddress address : mailAddresses) {
            builder.add((Object)address);
        }
        return builder.build();
    }

    @Override
    public List<MailAddress> getRecipients(Mail originalMail) throws MessagingException {
        return RecipientsUtils.from(this).getRecipients(originalMail);
    }

    @Override
    public Optional<MailAddress> getReversePath() throws MessagingException {
        return SpecialAddressesUtils.from(this).getFirstSpecialAddressIfMatchingOrGivenAddress(this.getInitParameters().getReversePath(), RedirectNotify.REVERSE_PATH_ALLOWED_SPECIALS);
    }

    @Override
    public Optional<MailAddress> getReversePath(Mail originalMail) throws MessagingException {
        Optional<MailAddress> reversePath = this.getReversePath();
        if (reversePath.isPresent() && MailAddressUtils.isUnalteredOrReversePathOrSender(reversePath.get())) {
            return Optional.empty();
        }
        return reversePath;
    }

    @Override
    public Optional<MailAddress> getSender() throws MessagingException {
        return SpecialAddressesUtils.from(this).getFirstSpecialAddressIfMatchingOrGivenAddress(this.getInitParameters().getSender(), RedirectNotify.SENDER_ALLOWED_SPECIALS);
    }

    @Override
    public Optional<MailAddress> getSender(Mail originalMail) throws MessagingException {
        return SenderUtils.from(this.getSender()).getSender(originalMail);
    }

    @Override
    public Optional<String> getSubjectPrefix(Mail newMail, String subjectPrefix, Mail originalMail) throws MessagingException {
        return new MimeMessageUtils(newMail.getMessage()).subjectWithPrefix(subjectPrefix, originalMail, this.getInitParameters().getSubject());
    }

    @Override
    public MimeMessageModifier getMimeMessageModifier(Mail newMail, Mail originalMail) throws MessagingException {
        return new MimeMessageModifier(newMail.getMessage());
    }

    @Override
    public void service(Mail originalMail) throws MessagingException {
        ProcessRedirectNotify.from(this).process(originalMail);
    }
}

