/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.mail.MessagingException;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.Mappings;
import org.apache.james.server.core.MailImpl;
import org.apache.james.util.MemoizedSupplier;
import org.apache.james.util.OptionalUtils;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecipientRewriteTableProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecipientRewriteTableProcessor.class);
    private final RecipientRewriteTable virtualTableStore;
    private final MailetContext mailetContext;
    private final Supplier<Domain> defaultDomainSupplier;
    private final String errorProcessor;

    public RecipientRewriteTableProcessor(RecipientRewriteTable virtualTableStore, DomainList domainList, MailetContext mailetContext, String errorProcessor) {
        this.virtualTableStore = virtualTableStore;
        this.mailetContext = mailetContext;
        this.defaultDomainSupplier = MemoizedSupplier.of((Supplier)Throwing.supplier(() -> this.getDefaultDomain(domainList)).sneakyThrow());
        this.errorProcessor = errorProcessor;
    }

    public RecipientRewriteTableProcessor(RecipientRewriteTable virtualTableStore, DomainList domainList, MailetContext mailetContext) {
        this(virtualTableStore, domainList, mailetContext, "error");
    }

    private Domain getDefaultDomain(DomainList domainList) throws MessagingException {
        try {
            return domainList.getDefaultDomain();
        }
        catch (DomainListException e) {
            throw new MessagingException("Unable to access DomainList", (Exception)((Object)e));
        }
    }

    public void processMail(Mail mail) throws MessagingException {
        RrtExecutionResult executionResults = this.executeRrtFor(mail);
        if (!executionResults.recipientWithError.isEmpty()) {
            MailImpl newMail = MailImpl.builder().name(mail.getName()).sender(mail.getMaybeSender()).recipients((List)executionResults.recipientWithError).mimeMessage(mail.getMessage()).state(this.errorProcessor).build();
            this.mailetContext.sendMail((Mail)newMail);
        }
        if (executionResults.newRecipients.isEmpty()) {
            mail.setState("ghost");
        }
        mail.setRecipients((Collection)executionResults.newRecipients);
    }

    private RrtExecutionResult executeRrtFor(Mail mail) {
        Function<MailAddress, RrtExecutionResult> convertToMappingData = recipient -> {
            Preconditions.checkNotNull((Object)recipient);
            return this.executeRrtForRecipient(mail, (MailAddress)recipient);
        };
        return mail.getRecipients().stream().map(convertToMappingData).reduce(RrtExecutionResult.empty(), (x$0, x$1) -> RrtExecutionResult.merge((RrtExecutionResult)x$0, (RrtExecutionResult)x$1));
    }

    private RrtExecutionResult executeRrtForRecipient(Mail mail, MailAddress recipient) {
        try {
            Mappings mappings = this.virtualTableStore.getResolvedMappings(recipient.getLocalPart(), recipient.getDomain());
            if (mappings != null && !mappings.isEmpty()) {
                List<MailAddress> newMailAddresses = this.handleMappings(mappings, mail, recipient);
                return RrtExecutionResult.success(newMailAddresses);
            }
            return RrtExecutionResult.success(recipient);
        }
        catch (RecipientRewriteTable.ErrorMappingException | RecipientRewriteTableException e) {
            LOGGER.warn("Could not rewrite recipient {}", (Object)recipient, (Object)e);
            return RrtExecutionResult.error(recipient);
        }
    }

    @VisibleForTesting
    List<MailAddress> handleMappings(Mappings mappings, Mail mail, MailAddress recipient) {
        boolean isLocal = true;
        Map<Boolean, List<MailAddress>> mailAddressSplit = mappings.asStream().map(mapping -> mapping.appendDomainIfNone(this.defaultDomainSupplier)).map(Mapping::asMailAddress).flatMap(OptionalUtils::toStream).collect(Collectors.partitioningBy(mailAddress -> this.mailetContext.isLocalServer(mailAddress.getDomain())));
        this.forwardToRemoteAddress(mail, recipient, (Collection<MailAddress>)mailAddressSplit.get(!isLocal));
        return mailAddressSplit.get(isLocal);
    }

    private void forwardToRemoteAddress(Mail mail, MailAddress recipient, Collection<MailAddress> remoteRecipients) {
        if (!remoteRecipients.isEmpty()) {
            try {
                this.mailetContext.sendMail((Mail)MailImpl.builder().name(mail.getName()).sender(mail.getMaybeSender()).recipients((List)ImmutableList.copyOf(remoteRecipients)).mimeMessage(mail.getMessage()).build());
                LOGGER.info("Mail for {} forwarded to {}", (Object)recipient, remoteRecipients);
            }
            catch (MessagingException ex) {
                LOGGER.warn("Error forwarding mail to {}", remoteRecipients);
            }
        }
    }

    private static class RrtExecutionResult {
        private final ImmutableList<MailAddress> newRecipients;
        private final ImmutableList<MailAddress> recipientWithError;

        private static RrtExecutionResult empty() {
            return new RrtExecutionResult((ImmutableList<MailAddress>)ImmutableList.of(), (ImmutableList<MailAddress>)ImmutableList.of());
        }

        private static RrtExecutionResult error(MailAddress mailAddress) {
            return new RrtExecutionResult((ImmutableList<MailAddress>)ImmutableList.of(), (ImmutableList<MailAddress>)ImmutableList.of((Object)mailAddress));
        }

        private static RrtExecutionResult success(MailAddress mailAddress) {
            return new RrtExecutionResult((ImmutableList<MailAddress>)ImmutableList.of((Object)mailAddress), (ImmutableList<MailAddress>)ImmutableList.of());
        }

        private static RrtExecutionResult success(List<MailAddress> mailAddresses) {
            return new RrtExecutionResult((ImmutableList<MailAddress>)ImmutableList.copyOf(mailAddresses), (ImmutableList<MailAddress>)ImmutableList.of());
        }

        private static RrtExecutionResult merge(RrtExecutionResult result1, RrtExecutionResult result2) {
            return new RrtExecutionResult((ImmutableList<MailAddress>)ImmutableList.builder().addAll(result1.getNewRecipients()).addAll(result2.getNewRecipients()).build(), (ImmutableList<MailAddress>)ImmutableList.builder().addAll(result1.getRecipientWithError()).addAll(result2.getRecipientWithError()).build());
        }

        public RrtExecutionResult(ImmutableList<MailAddress> newRecipients, ImmutableList<MailAddress> recipientWithError) {
            this.newRecipients = newRecipients;
            this.recipientWithError = recipientWithError;
        }

        public List<MailAddress> getNewRecipients() {
            return this.newRecipients;
        }

        public List<MailAddress> getRecipientWithError() {
            return this.recipientWithError;
        }
    }
}

