/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import org.apache.commons.io.IOUtils;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetException;
import org.apache.mailet.base.GenericMailet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeDecodingMailet
extends GenericMailet {
    private static final Logger LOGGER = LoggerFactory.getLogger(MimeDecodingMailet.class);
    public static final String ATTRIBUTE_PARAMETER_NAME = "attribute";
    private String attribute;

    public void init() throws MessagingException {
        this.attribute = this.getInitParameter(ATTRIBUTE_PARAMETER_NAME);
        if (Strings.isNullOrEmpty((String)this.attribute)) {
            throw new MailetException("No value for attribute parameter was provided.");
        }
    }

    public void service(Mail mail) throws MessagingException {
        if (mail.getAttribute(this.attribute) == null) {
            return;
        }
        ImmutableMap.Builder extractedMimeContentByName = ImmutableMap.builder();
        for (Map.Entry<String, byte[]> entry : this.getAttributeContent(mail).entrySet()) {
            Optional<byte[]> maybeContent = this.extractContent(entry.getValue());
            if (!maybeContent.isPresent()) continue;
            extractedMimeContentByName.put((Object)entry.getKey(), (Object)maybeContent.get());
        }
        mail.setAttribute(this.attribute, (Serializable)extractedMimeContentByName.build());
    }

    private Map<String, byte[]> getAttributeContent(Mail mail) throws MailetException {
        Serializable attributeContent = mail.getAttribute(this.attribute);
        if (!(attributeContent instanceof Map)) {
            LOGGER.debug("Invalid attribute found into attribute {} class Map expected but {} found.", (Object)this.attribute, attributeContent.getClass());
            return ImmutableMap.of();
        }
        return (Map)((Object)attributeContent);
    }

    private Optional<byte[]> extractContent(Object rawMime) throws MessagingException {
        try {
            MimeBodyPart mimeBodyPart = new MimeBodyPart((InputStream)new ByteArrayInputStream((byte[])rawMime));
            return Optional.ofNullable(IOUtils.toByteArray((InputStream)mimeBodyPart.getInputStream()));
        }
        catch (IOException e) {
            LOGGER.error("Error while extracting content from mime part", (Throwable)e);
            return Optional.empty();
        }
        catch (ClassCastException e) {
            LOGGER.error("Invalid map attribute types.", (Throwable)e);
            return Optional.empty();
        }
    }

    public String getMailetInfo() {
        return "MimeDecodingMailet";
    }
}

