/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core.fastfail;

import java.util.Collection;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookReturnCode;
import org.apache.james.protocols.smtp.hook.RcptHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupressDuplicateRcptHandler
implements RcptHook {
    private static final Logger LOGGER = LoggerFactory.getLogger(SupressDuplicateRcptHandler.class);

    public void init(Configuration config) throws ConfigurationException {
    }

    public void destroy() {
    }

    @Override
    public HookResult doRcpt(SMTPSession session, MaybeSender sender, MailAddress rcpt) {
        Collection rcptList = (Collection)session.getAttachment("RCPT_LIST", ProtocolSession.State.Transaction);
        if (rcptList != null && rcptList.contains(rcpt)) {
            StringBuilder responseBuffer = new StringBuilder();
            responseBuffer.append(DSNStatus.getStatus(2, "1.5")).append(" Recipient <").append(rcpt.toString()).append("> OK");
            LOGGER.debug("Duplicate recipient not add to recipient list: {}", (Object)rcpt);
            return HookResult.builder().hookReturnCode(HookReturnCode.ok()).smtpReturnCode("250").smtpDescription(responseBuffer.toString()).build();
        }
        return HookResult.DECLINED;
    }
}

