/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core.esmtp;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.CommandHandler;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.SMTPStartTlsResponse;
import org.apache.james.protocols.smtp.core.esmtp.EhloExtension;
import org.apache.james.protocols.smtp.dsn.DSNStatus;

public class StartTlsCmdHandler
implements CommandHandler<SMTPSession>,
EhloExtension {
    private static final String COMMAND_NAME = "STARTTLS";
    private static final Collection<String> COMMANDS = ImmutableSet.of((Object)"STARTTLS");
    private static final List<String> FEATURES = ImmutableList.of((Object)"STARTTLS");
    private static final Response TLS_ALREADY_ACTIVE = new SMTPResponse("500", DSNStatus.getStatus(5, "5.1") + " TLS already active RFC2487 5.2").immutable();
    private static final Response READY_FOR_STARTTLS = new SMTPStartTlsResponse("220", DSNStatus.getStatus(2, "0.0") + " Ready to start TLS").immutable();
    private static final Response SYNTAX_ERROR = new SMTPResponse("501 " + DSNStatus.getStatus(5, "5.4") + " Syntax error (no parameters allowed) with STARTTLS command").immutable();
    private static final Response NOT_SUPPORTED = new SMTPResponse("500", DSNStatus.getStatus(5, "5.1") + " Command " + "STARTTLS" + " unrecognized.").immutable();

    public Collection<String> getImplCommands() {
        return COMMANDS;
    }

    public void init(Configuration config) throws ConfigurationException {
    }

    public void destroy() {
    }

    public Response onCommand(SMTPSession session, Request request) {
        if (session.isStartTLSSupported()) {
            if (session.isTLSStarted()) {
                return TLS_ALREADY_ACTIVE;
            }
            String parameters = request.getArgument();
            if (parameters == null || parameters.length() == 0) {
                return READY_FOR_STARTTLS;
            }
            return SYNTAX_ERROR;
        }
        return NOT_SUPPORTED;
    }

    @Override
    public List<String> getImplementedEsmtpFeatures(SMTPSession session) {
        if (!session.isTLSStarted() && session.isStartTLSSupported()) {
            return FEATURES;
        }
        return Collections.EMPTY_LIST;
    }
}

