/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.CommandHandler;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.dsn.DSNStatus;

public class RsetCmdHandler
implements CommandHandler<SMTPSession> {
    private static final Collection<String> COMMANDS = ImmutableSet.of((Object)"RSET");
    private static final Response OK = new SMTPResponse("250", DSNStatus.getStatus(2, "0.0") + " OK").immutable();
    private static final Response SYNTAX_ERROR = new SMTPResponse("500", DSNStatus.getStatus(5, "5.4") + " Unexpected argument provided with RSET command").immutable();

    public Response onCommand(SMTPSession session, Request request) {
        return this.doRSET(session, request.getArgument());
    }

    private Response doRSET(SMTPSession session, String argument) {
        if (argument == null || argument.length() == 0) {
            session.resetState();
            return OK;
        }
        return SYNTAX_ERROR;
    }

    public Collection<String> getImplCommands() {
        return COMMANDS;
    }

    public void init(Configuration config) throws ConfigurationException {
    }

    public void destroy() {
    }
}

