/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core;

import com.google.common.base.Preconditions;
import java.util.Locale;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookReturnCode;
import org.apache.james.protocols.smtp.hook.RcptHook;

public abstract class AbstractSenderAuthIdentifyVerificationRcptHook
implements RcptHook {
    private static final HookResult INVALID_AUTH = HookResult.builder().hookReturnCode(HookReturnCode.deny()).smtpReturnCode("503").smtpDescription(DSNStatus.getStatus(5, "7.1") + " Incorrect Authentication for Specified Email Address").build();

    @Override
    public HookResult doRcpt(SMTPSession session, MaybeSender sender, MailAddress rcpt) {
        if (session.getUser() != null) {
            MaybeSender senderAddress = (MaybeSender)session.getAttachment("SENDER_ADDRESS", ProtocolSession.State.Transaction);
            if (this.isAnonymous(sender) || !this.senderMatchSessionUser(sender, session) || !this.belongsToLocalDomain(senderAddress)) {
                return INVALID_AUTH;
            }
        }
        return HookResult.DECLINED;
    }

    private boolean isAnonymous(MaybeSender maybeSender) {
        return maybeSender == null || maybeSender.isNullSender();
    }

    private boolean senderMatchSessionUser(MaybeSender maybeSender, SMTPSession session) {
        Preconditions.checkArgument((!maybeSender.isNullSender() ? 1 : 0) != 0);
        String authUser = session.getUser().toLowerCase(Locale.US);
        String username = this.getUser(maybeSender.get());
        return username.equals(authUser);
    }

    private boolean belongsToLocalDomain(MaybeSender maybeSender) {
        Preconditions.checkArgument((!maybeSender.isNullSender() ? 1 : 0) != 0);
        return this.isLocalDomain(maybeSender.get().getDomain());
    }

    protected abstract boolean isLocalDomain(Domain var1);

    protected abstract String getUser(MailAddress var1);
}

