/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.CommandHandler;
import org.apache.james.protocols.api.handler.ExtensibleHandler;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.hook.Hook;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookResultHook;
import org.apache.james.protocols.smtp.hook.HookReturnCode;
import org.apache.james.util.OptionalUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHookableCmdHandler<HookT extends Hook>
implements CommandHandler<SMTPSession>,
ExtensibleHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractHookableCmdHandler.class);
    private final MetricFactory metricFactory;
    private List<HookT> hooks;
    private List<HookResultHook> rHooks;

    @Inject
    public AbstractHookableCmdHandler(MetricFactory metricFactory) {
        this.metricFactory = metricFactory;
    }

    /*
     * Exception decompiling
     */
    public Response onCommand(SMTPSession session, Request request) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Response processHooks(SMTPSession session, String command, String parameters) {
        List<HookT> hooks = this.getHooks();
        if (hooks != null) {
            int count = hooks.size();
            for (int i = 0; i < count; ++i) {
                Hook rawHook = (Hook)hooks.get(i);
                LOGGER.debug("executing hook {}", (Object)rawHook.getClass().getName());
                long start = System.currentTimeMillis();
                HookResult hRes = this.callHook(rawHook, session, parameters);
                long executionTime = System.currentTimeMillis() - start;
                if (this.rHooks != null) {
                    for (HookResultHook rHook : this.rHooks) {
                        LOGGER.debug("executing hook {}", (Object)rHook);
                        hRes = rHook.onHookResult(session, hRes, executionTime, rawHook);
                    }
                }
                if (hRes.getResult().getAction() == HookReturnCode.Action.OK) {
                    final Response response = this.doCoreCmd(session, command, parameters);
                    if (hRes.getResult().isDisconnected()) {
                        return new Response(){

                            public boolean isEndSession() {
                                return true;
                            }

                            public String getRetCode() {
                                return response.getRetCode();
                            }

                            public List<CharSequence> getLines() {
                                return response.getLines();
                            }
                        };
                    }
                    return response;
                }
                SMTPResponse res = AbstractHookableCmdHandler.calcDefaultSMTPResponse(hRes);
                if (res == null) continue;
                return res;
            }
        }
        return null;
    }

    protected abstract HookResult callHook(HookT var1, SMTPSession var2, String var3);

    public static SMTPResponse calcDefaultSMTPResponse(HookResult result) {
        if (result != null) {
            HookReturnCode returnCode = result.getResult();
            String smtpReturnCode = OptionalUtils.or((Optional[])new Optional[]{Optional.ofNullable(result.getSmtpRetCode()), AbstractHookableCmdHandler.retrieveDefaultSmtpReturnCode(returnCode)}).orElse(null);
            String smtpDescription = OptionalUtils.or((Optional[])new Optional[]{Optional.ofNullable(result.getSmtpDescription()), AbstractHookableCmdHandler.retrieveDefaultSmtpDescription(returnCode)}).orElse(null);
            if (AbstractHookableCmdHandler.canBeConvertedToSmtpAnswer(returnCode)) {
                SMTPResponse response = new SMTPResponse(smtpReturnCode, smtpDescription);
                if (returnCode.isDisconnected()) {
                    response.setEndSession(true);
                }
                return response;
            }
        }
        return null;
    }

    public static boolean canBeConvertedToSmtpAnswer(HookReturnCode returnCode) {
        return HookReturnCode.Action.ACTIVE_ACTIONS.contains((Object)returnCode.getAction()) || returnCode.isDisconnected();
    }

    private static Optional<String> retrieveDefaultSmtpDescription(HookReturnCode returnCode) {
        switch (returnCode.getAction()) {
            case DENY: {
                return Optional.of("Email rejected");
            }
            case DENYSOFT: {
                return Optional.of("Temporary problem. Please try again later");
            }
            case OK: {
                return Optional.of("Command accepted");
            }
        }
        if (returnCode.isDisconnected()) {
            return Optional.of("Server disconnected");
        }
        return Optional.empty();
    }

    private static Optional<String> retrieveDefaultSmtpReturnCode(HookReturnCode returnCode) {
        switch (returnCode.getAction()) {
            case DENY: {
                return Optional.of("554");
            }
            case DENYSOFT: {
                return Optional.of("451");
            }
            case OK: {
                return Optional.of("250");
            }
        }
        if (returnCode.isDisconnected()) {
            return Optional.of("554");
        }
        return Optional.empty();
    }

    protected abstract Response doFilterChecks(SMTPSession var1, String var2, String var3);

    protected abstract Response doCoreCmd(SMTPSession var1, String var2, String var3);

    public List<Class<?>> getMarkerInterfaces() {
        ArrayList classes = new ArrayList(2);
        classes.add(this.getHookInterface());
        classes.add(HookResultHook.class);
        return classes;
    }

    protected abstract Class<HookT> getHookInterface();

    public void wireExtensions(Class<?> interfaceName, List<?> extension) {
        if (this.getHookInterface().equals(interfaceName)) {
            this.hooks = extension;
        } else if (HookResultHook.class.equals(interfaceName)) {
            this.rHooks = extension;
        }
    }

    protected List<HookT> getHooks() {
        return this.hooks;
    }
}

