/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.activemq;

import java.io.IOException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import org.apache.activemq.command.ActiveMQBlobMessage;
import org.apache.james.queue.activemq.ActiveMQSupport;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.jms.JMSMailQueueItem;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQMailQueueItem
extends JMSMailQueueItem
implements ActiveMQSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActiveMQMailQueueItem.class);
    private final Message message;

    public ActiveMQMailQueueItem(Mail mail, Session session, MessageConsumer consumer, Message message) {
        super(mail, session, consumer);
        this.message = message;
    }

    public void done(boolean success) throws MailQueue.MailQueueException {
        super.done(success);
        if (success) {
            if (this.message instanceof ActiveMQBlobMessage && this.getMail().getAttribute(" JAMES_REUSE_BLOB_URL") == null) {
                try {
                    ((ActiveMQBlobMessage)this.message).deleteFile();
                }
                catch (IOException | JMSException e) {
                    LOGGER.warn("Unable to delete blob message file for mail {}", (Object)this.getMail().getName());
                }
            }
            this.getMail().removeAttribute(" JAMES_REUSE_BLOB_URL");
        }
    }
}

