/****************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one   *
 * or more contributor license agreements.  See the NOTICE file *
 * distributed with this work for additional information        *
 * regarding copyright ownership.  The ASF licenses this file   *
 * to you under the Apache License, Version 2.0 (the            *
 * "License"); you may not use this file except in compliance   *
 * with the License.  You may obtain a copy of the License at   *
 *                                                              *
 *   http://www.apache.org/licenses/LICENSE-2.0                 *
 *                                                              *
 * Unless required by applicable law or agreed to in writing,   *
 * software distributed under the License is distributed on an  *
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY       *
 * KIND, either express or implied.  See the License for the    *
 * specific language governing permissions and limitations      *
 * under the License.                                           *
 ****************************************************************/

package org.apache.james.mdn.modifier;

import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

import nl.jqno.equalsverifier.EqualsVerifier;

public class DispositionModifierTest {

    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void shouldMatchBeanContract() throws Exception {
        EqualsVerifier.forClass(DispositionModifier.class)
            .verify();
    }

    @Test
    public void shouldThrowOnNull() {
        expectedException.expect(NullPointerException.class);

        new DispositionModifier(null);
    }

    @Test
    public void shouldThrowOnMultiLine() {
        expectedException.expect(IllegalArgumentException.class);

        new DispositionModifier("multi\nline");
    }

    @Test
    public void shouldThrowOnEndBreakLine() {
        expectedException.expect(IllegalArgumentException.class);

        new DispositionModifier("multi\n");
    }

    @Test
    public void shouldThrowOnBeginningBreakLine() {
        expectedException.expect(IllegalArgumentException.class);

        new DispositionModifier("\nline");
    }

    @Test
    public void shouldThrowOnEmptyValue() {
        expectedException.expect(IllegalArgumentException.class);

        new DispositionModifier("");
    }

    @Test
    public void shouldThrowOnFoldingWhiteSpaceValue() {
        expectedException.expect(IllegalArgumentException.class);

        new DispositionModifier("    ");
    }
}
