# Upgrade instructions

This document covers every changes an Ops needs to be aware of when running James.

The following procedures are to take as it, and the Apache Software Foundation, nor its contributors, can not be 
responsible for any damages generated by following the below procedures.

Before performing these operations, you should ensure to have the skills to conduct the operations, and you should read other
software documentation. Do not follow this guide blindly!

## Unreleased

Note: this section is in progress. It will be updated during all the development process until the release.

Changes to apply between 3.1.x and 3.2.x will be reported here.

Changelist:

 - [JMAPFiltering mailet is required for JMAP capable servers](#jmapfiltering-mailet-is-required-for-jmap-capable-servers)
 - [Cassandra 3.11.3 upgrade](#cassandra-3113-upgrade)

### JMAPFiltering mailet is required for JMAP capable servers

Date: 30/08/2018

SHA-1: 9ba6a1dd270f99735c7f9d3d4b2adb5076583c10

JIRA: https://issues.apache.org/jira/browse/JAMES-2529

Required: Yes

Concerned products: Cassandra Guice products

This mailet allow users filtering rules to be applied for incoming emails.

#### Upgrade procedure

Add this line before the `LocalDelivery` mailet of your `transport` processor:

```
<mailet match="RecipientIsLocal" class="org.apache.james.jmap.mailet.filter.JMAPFiltering"/>
```

### Cassandra 3.11.3 upgrade

Date: 03/08/2018

SHA-1: de0fa8a3df69f50cbc0684dfb1b911ad497856d7

JIRA: https://issues.apache.org/jira/browse/JAMES-2514

Required: Yes

Concerned products: Cassandra Guice products

James Cassandra Guice now officially uses Cassandra 3.11.3 as a storage backend. After performing the upgrade, the team
did perform some breaking changes, detailed below. James Cassandra Guice products are no more tested against Cassandra 2.2.x. Thus we strongly
advise our users to upgrade.

#### Changes not compatible with Cassandra 2.2.x

Replace in default compaction strategies "DateTieredCompactionStrategy" by "TimeWindowCompactionStrategy".

This means you can no more start James on top of an empty Cassandra 2.2.x cluster, but existing deployments should not be impacted.

#### Upgrade procedure

We will assume that Cassandra had been installed with a debian package. Upgrade procedure stays similar in other cases.


1. Update Cassandra dists in `/etc/apt/sources.list.d/cassandra.list` to match 311x repository

```
deb http://www.apache.org/dist/cassandra/debian 311x main
```


2. Update Cassandra

```
$ apt-get update
$ apt-get install cassandra=3.11.3
```

3. Correct the configuration

Edit /etc/cassandra/cassandra.yaml and ensure to really specify the interface cassandra is listening on as seeds.

4. ReStart Cassandra

4.1. Drain data & stop

```
$ nodetool drain
$ nodetool stop
```

4.2. start Cassandra

5. Upgrade SSTable (live update, performance degradation to expect)

```
$ nodetool upgradesstables apache_james
```

