/****************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one   *
 * or more contributor license agreements.  See the NOTICE file *
 * distributed with this work for additional information        *
 * regarding copyright ownership.  The ASF licenses this file   *
 * to you under the Apache License, Version 2.0 (the            *
 * "License"); you may not use this file except in compliance   *
 * with the License.  You may obtain a copy of the License at   *
 *                                                              *
 *   http://www.apache.org/licenses/LICENSE-2.0                 *
 *                                                              *
 * Unless required by applicable law or agreed to in writing,   *
 * software distributed under the License is distributed on an  *
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY       *
 * KIND, either express or implied.  See the License for the    *
 * specific language governing permissions and limitations      *
 * under the License.                                           *
 ****************************************************************/
package org.apache.james.domainlist.hbase;

import java.io.IOException;

import org.apache.james.core.Domain;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.domainlist.lib.AbstractDomainListTest;
import org.apache.james.mailbox.hbase.HBaseClusterSingleton;
import org.apache.james.system.hbase.TablePool;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

/**
 * Tests for the HBase DomainList implementation.
 *
 * Simply create the needed HBaseDomainList instance, and let the
 * AbstractDomainListTest run the tests
 */
public class HBaseDomainListTest extends AbstractDomainListTest {

    private static final HBaseClusterSingleton cluster = HBaseClusterSingleton.build();

    @BeforeClass
    public static void setMeUp() throws IOException {
        TablePool.getInstance(cluster.getConf());
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }
    
    @After
    public void tearDown() throws Exception {
        DomainList domainList = createDomainList();
        for (Domain domain: domainList.getDomains()) {
            domainList.removeDomain(domain);
        }
    }

    @Override
    protected DomainList createDomainList() throws Exception {
        HBaseDomainList domainList = new HBaseDomainList(getDNSServer("localhost"));
        domainList.setAutoDetect(false);
        domainList.setAutoDetectIP(false);
        return domainList;
    }

    @Ignore
    @Test
    @Override
    public void removeDomainShouldThrowIfTheDomainIsAbsent() throws DomainListException {

    }
}
